/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.installers;

import com.foreach.across.core.annotations.InstallerMethod;
import com.foreach.across.modules.webcms.data.WebCmsDataImportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.Yaml;

public abstract class AbstractWebCmsDataInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebCmsDataInstaller.class);
    private ApplicationContext applicationContext;
    private WebCmsDataImportService dataImportService;
    private Collection<Resource> resources = new ArrayList<Resource>();

    @PostConstruct
    final void autoRegisterResources() {
        ArrayList<String> list = new ArrayList<String>();
        this.registerResources(list);
        list.forEach(this::addResource);
    }

    public void addResource(String location) {
        this.addResource(this.applicationContext.getResource(location));
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    protected abstract void registerResources(List<String> var1);

    @InstallerMethod
    public void install() throws Exception {
        Yaml yaml = new Yaml();
        this.resources.forEach(resource -> {
            try {
                LOG.info("Importing YAML data from: " + resource);
                Map data = (Map)yaml.load(resource.getInputStream());
                this.dataImportService.importData(data, resource.toString());
                LOG.info("Finished importing YAML data from: " + resource);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired
    public void setDataImportService(WebCmsDataImportService dataImportService) {
        this.dataImportService = dataImportService;
    }
}

