/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.component.container.ContainerWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelHierarchy;
import com.foreach.across.modules.webcms.domain.component.proxy.ProxyWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsUriComponentsService;
import com.foreach.across.modules.webcms.domain.image.WebCmsImage;
import com.foreach.across.modules.webcms.domain.image.component.ImageWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.image.connector.WebCmsImageConnector;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service(value="wcmRenderUtils")
public class WebCmsRenderUtilityService {
    private final WebCmsImageConnector imageConnector;
    private final WebCmsComponentModelHierarchy componentModelHierarchy;
    private final WebCmsEndpointService endpointService;
    private final WebCmsUriComponentsService uriComponentsService;

    public String imageUrl(ImageWebCmsComponentModel imageComponent) {
        return this.imageUrl(imageComponent, 0, 0);
    }

    public String imageUrl(ImageWebCmsComponentModel imageComponent, int boxWidth, int boxHeight) {
        return imageComponent.isEmpty() ? null : this.imageUrl(imageComponent.getImage(), boxWidth, boxHeight);
    }

    public String imageUrl(WebCmsImage image) {
        return this.imageUrl(image, 0, 0);
    }

    public String imageUrl(WebCmsImage image, int boxWidth, int boxHeight) {
        return this.imageConnector.buildImageUrl(image, boxWidth, boxHeight);
    }

    public WebCmsComponentModel component(String componentName) {
        return this.componentModelHierarchy.get(componentName);
    }

    public WebCmsComponentModel componentFromScope(String componentName, String scopeName) {
        return this.componentModelHierarchy.getFromScope(componentName, scopeName);
    }

    public WebCmsComponentModel componentFromScope(String componentName, String scopeName, boolean searchParentScopes) {
        return this.componentModelHierarchy.getFromScope(componentName, scopeName, searchParentScopes);
    }

    public WebCmsComponentModel member(String componentName, WebCmsComponentModel container) {
        WebCmsComponentModel target;
        WebCmsComponentModel webCmsComponentModel = target = container instanceof ProxyWebCmsComponentModel ? ((ProxyWebCmsComponentModel)container).getTarget() : container;
        if (target instanceof ContainerWebCmsComponentModel) {
            return ((ContainerWebCmsComponentModel)target).getMember(componentName);
        }
        return null;
    }

    public List<WebCmsComponentModel> members(WebCmsComponentModel container) {
        WebCmsComponentModel target;
        WebCmsComponentModel webCmsComponentModel = target = container instanceof ProxyWebCmsComponentModel ? ((ProxyWebCmsComponentModel)container).getTarget() : container;
        if (target instanceof ContainerWebCmsComponentModel) {
            return ((ContainerWebCmsComponentModel)target).getMembers();
        }
        return Collections.emptyList();
    }

    public String url(WebCmsAsset asset) {
        return this.uriComponentsService.buildUriComponents(asset).map(UriComponentsBuilder::toUriString).orElse(null);
    }

    public WebCmsRenderUtilityService(WebCmsImageConnector imageConnector, WebCmsComponentModelHierarchy componentModelHierarchy, WebCmsEndpointService endpointService, WebCmsUriComponentsService uriComponentsService) {
        this.imageConnector = imageConnector;
        this.componentModelHierarchy = componentModelHierarchy;
        this.endpointService = endpointService;
        this.uriComponentsService = uriComponentsService;
    }
}

