/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateQueue;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateTask;
import com.foreach.across.modules.webcms.web.thymeleaf.ExpressionParser;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.element.IElementModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.processor.element.MatchingAttributeName;
import org.thymeleaf.processor.element.MatchingElementName;
import org.thymeleaf.templatemode.TemplateMode;

final class ComponentAttributeElementProcessor
extends AbstractProcessor
implements IElementModelProcessor {
    private final MatchingElementName matchingElementName = MatchingElementName.forAllElementsWithPrefix((TemplateMode)TemplateMode.HTML, (String)"wcm");

    ComponentAttributeElementProcessor() {
        super(TemplateMode.HTML, 1000);
    }

    public void process(ITemplateContext context, IModel model, IElementModelStructureHandler structureHandler) {
        IProcessableElementTag tag;
        Type attributeType;
        ITemplateEvent templateEvent = model.get(0);
        if (templateEvent instanceof IProcessableElementTag && (attributeType = this.resolveAttributeType(tag = (IProcessableElementTag)templateEvent)) != null) {
            WebApplicationContext appCtx = RequestContextUtils.findWebApplicationContext((HttpServletRequest)((WebEngineContext)context).getRequest());
            WebCmsComponentAutoCreateQueue queue = (WebCmsComponentAutoCreateQueue)appCtx.getBean(WebCmsComponentAutoCreateQueue.class);
            WebCmsComponentAutoCreateTask currentTask = queue.getCurrentTask();
            if (currentTask != null) {
                ExpressionParser expressionParser = ExpressionParser.create(context);
                IAttribute nameAttribute = tag.getAttribute("name");
                if (nameAttribute == null) {
                    throw new IllegalStateException(attributeType.tag + " element requires a 'name' attribute");
                }
                String name = (String)expressionParser.parse(nameAttribute.getValue());
                IAttribute valueAttribute = tag.getAttribute("value");
                if (valueAttribute != null) {
                    Object value = expressionParser.parse(valueAttribute.getValue());
                    currentTask.addAttributeValue(attributeType.attributeType, name, value);
                    model.reset();
                } else {
                    IModelFactory modelFactory = context.getModelFactory();
                    model.remove(0);
                    if (tag instanceof IOpenElementTag) {
                        model.remove(model.size() - 1);
                    }
                    model.insert(0, (ITemplateEvent)modelFactory.createOpenElementTag("th:block", tag.getAttributeMap(), AttributeValueQuotes.DOUBLE, false));
                    model.insert(0, (ITemplateEvent)modelFactory.createProcessingInstruction("render-to-attribute-start", attributeType.attributeType.name() + ":" + name));
                    model.add((ITemplateEvent)modelFactory.createCloseElementTag("th:block"));
                    model.add((ITemplateEvent)modelFactory.createProcessingInstruction("render-to-attribute-finish", ""));
                }
            } else {
                model.reset();
            }
        }
    }

    private Type resolveAttributeType(IProcessableElementTag tag) {
        if (Type.METADATA.tag.equals(tag.getElementCompleteName())) {
            return Type.METADATA;
        }
        if (Type.PROPERTY.tag.equals(tag.getElementCompleteName())) {
            return Type.PROPERTY;
        }
        if (Type.ATTRIBUTE.tag.equals(tag.getElementCompleteName())) {
            return Type.ATTRIBUTE;
        }
        return null;
    }

    public MatchingElementName getMatchingElementName() {
        return this.matchingElementName;
    }

    public MatchingAttributeName getMatchingAttributeName() {
        return null;
    }

    private static enum Type {
        ATTRIBUTE("wcm:component-attribute", WebCmsComponentAutoCreateTask.Attribute.ANY),
        PROPERTY("wcm:component-property", WebCmsComponentAutoCreateTask.Attribute.PROPERTY),
        METADATA("wcm:component-metadata", WebCmsComponentAutoCreateTask.Attribute.METADATA);

        private final String tag;
        private final WebCmsComponentAutoCreateTask.Attribute attributeType;

        private Type(String tag, WebCmsComponentAutoCreateTask.Attribute attributeType) {
            this.tag = tag;
            this.attributeType = attributeType;
        }
    }
}

