/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.modules.webcms.domain.component.WebCmsComponentUtils;
import com.foreach.across.modules.webcms.domain.component.WebCmsContentMarker;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelHierarchy;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateQueue;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateTask;
import com.foreach.across.modules.webcms.web.thymeleaf.ExpressionParser;
import com.foreach.across.modules.webcms.web.thymeleaf.ModelProcessingState;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.AbstractAttributeModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

final class ComponentAttributeProcessor
extends AbstractAttributeModelProcessor {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final String ATTR_SEARCH_PARENTS = "wcm:search-parent-scopes";
    private static final String ATTR_TYPE = "wcm:type";
    private static final String ATTR_ALWAYS_REPLACE = "wcm:always-replace";
    private static final String ATTR_PARSE_PLACEHOLDERS = "wcm:parse-placeholders";
    static final String ATTR_COMPONENT = "wcm:component";
    static final String ATTR_AUTO_CREATE = "wcm:auto-create";
    static final String ATTR_SCOPE = "wcm:scope";
    static final String ATTR_PARENT_CREATE_INCLUDE = "wcm:parent-create-include";
    static final String ATTR_META_PREFIX = "wcm:meta";
    static final String ATTR_PROP_PREFIX = "wcm:prop";
    static final String ATTR_ATTR_PREFIX = "wcm:attr";
    private static final Collection<String> FIXED_ATTRIBUTES_TO_REMOVE = Arrays.asList("wcm:component", "wcm:scope", "wcm:search-parent-scopes", "wcm:auto-create", "wcm:type", "wcm:always-replace", "wcm:parse-placeholders", "wcm:parent-create-include");

    ComponentAttributeProcessor() {
        super(TemplateMode.HTML, "wcm", null, false, "component", true, 100, false);
    }

    protected void doProcess(ITemplateContext templateContext, IModel model, AttributeName attributeName, String attributeValue, IElementModelStructureHandler structureHandler) {
        if (model.size() > 0 && model.get(0) instanceof IProcessableElementTag) {
            ModelProcessingState modelProcessingState = ModelProcessingState.retrieve(templateContext);
            ExpressionParser expressionParser = ExpressionParser.create(templateContext);
            IProcessableElementTag elementTag = (IProcessableElementTag)model.get(0);
            boolean isStandaloneTag = elementTag instanceof IStandaloneElementTag;
            IModelFactory modelFactory = templateContext.getModelFactory();
            boolean ignoreComponent = modelProcessingState.isParsePlaceholdersOnly();
            if (!ignoreComponent) {
                boolean createProxy;
                WebCmsComponentModelHierarchy components = modelProcessingState.getComponentModelHierarchy();
                String lookupScope = this.resolveLookupScope(elementTag, modelProcessingState);
                ComponentModelLookup lookupResult = this.lookupWebComponentModel(attributeValue, elementTag, components, lookupScope);
                WebCmsComponentAutoCreateQueue creationQueue = modelProcessingState.getAutoCreateQueue();
                WebCmsComponentAutoCreateTask currentCreationTask = creationQueue.getCurrentTask();
                boolean parsePlaceholders = elementTag.getAttribute(ATTR_PARSE_PLACEHOLDERS) != null;
                boolean shouldRenderComponentOutput = currentCreationTask == null || elementTag.hasAttribute(ATTR_PARENT_CREATE_INCLUDE) || modelProcessingState.isInsidePlaceholder();
                String creationScope = this.resolveCreationScope(elementTag, modelProcessingState, lookupScope);
                boolean bl = createProxy = !shouldRenderComponentOutput && WebCmsComponentUtils.isContainerType(currentCreationTask.getComponentType());
                if (lookupResult != null && lookupResult.hasComponentModel()) {
                    elementTag = this.renderComponentModel((IEngineContext)templateContext, model, elementTag, modelFactory, lookupResult.getComponentModel(), parsePlaceholders, shouldRenderComponentOutput, createProxy);
                } else {
                    boolean shouldRenderComponentDuringCreation;
                    boolean bl2 = shouldRenderComponentDuringCreation = currentCreationTask == null || elementTag.hasAttribute(ATTR_PARENT_CREATE_INCLUDE);
                    if (creationScope != null) {
                        this.autoCreateComponent(model, attributeValue, elementTag, isStandaloneTag, modelFactory, parsePlaceholders, creationQueue, creationScope, shouldRenderComponentDuringCreation, createProxy &= !"container".equals(creationScope), expressionParser);
                    } else if (elementTag.hasAttribute(ATTR_ALWAYS_REPLACE) || !shouldRenderComponentDuringCreation) {
                        this.renderEmptyBody(model, elementTag);
                    }
                }
                if (!shouldRenderComponentOutput) {
                    if (createProxy) {
                        model.insert(1, (ITemplateEvent)modelFactory.createProcessingInstruction("component-render", new WebCmsContentMarker(ATTR_COMPONENT, attributeValue + ",container,false").toString()));
                    } else {
                        this.writeComponentContentMarker(model, modelFactory, lookupResult);
                    }
                }
            }
            this.removeProcessedAttributesFromTag(model, elementTag, modelFactory);
        }
    }

    private String resolveLookupScope(IProcessableElementTag elementTag, ModelProcessingState modelProcessingState) {
        IAttribute attribute = elementTag.getAttribute(ATTR_SCOPE);
        String scope = null;
        if (attribute == null) {
            WebCmsComponentAutoCreateTask currentTask;
            if (!modelProcessingState.isInsidePlaceholder() && (currentTask = modelProcessingState.getAutoCreateQueue().getCurrentTask()) != null && WebCmsComponentUtils.isContainerType(currentTask.getComponentType())) {
                scope = "container";
            }
        } else {
            scope = attribute.getValue();
        }
        return scope;
    }

    private String resolveCreationScope(IProcessableElementTag elementTag, ModelProcessingState modelProcessingState, String lookupScope) {
        String creationScope = null;
        IAttribute attribute = elementTag.getAttribute(ATTR_AUTO_CREATE);
        if (attribute != null) {
            creationScope = attribute.getValue();
            if (creationScope == null) {
                creationScope = lookupScope;
            }
            if (creationScope == null) {
                creationScope = modelProcessingState.getComponentModelHierarchy().getDefaultScope();
            }
        } else if ("container".equals(lookupScope)) {
            creationScope = "container";
        }
        if (modelProcessingState.isInsidePlaceholder() && "container".equals(creationScope)) {
            return null;
        }
        return creationScope;
    }

    private void writeComponentContentMarker(IModel model, IModelFactory modelFactory, ComponentModelLookup lookupResult) {
        if (lookupResult != null) {
            model.insert(1, (ITemplateEvent)modelFactory.createProcessingInstruction("component-render", lookupResult.toString()));
        }
    }

    private void autoCreateComponent(IModel model, String attributeValue, IProcessableElementTag elementTag, boolean isStandaloneTag, IModelFactory modelFactory, boolean parsePlaceholders, WebCmsComponentAutoCreateQueue queue, String creationScope, boolean shouldRenderComponent, boolean createProxy, ExpressionParser expressionParser) {
        String componentType = elementTag.getAttributeValue(ATTR_TYPE);
        WebCmsComponentAutoCreateTask task = queue.schedule(attributeValue, creationScope, componentType);
        if (isStandaloneTag) {
            this.renderEmptyBody(model, elementTag);
            model.add((ITemplateEvent)modelFactory.createProcessingInstruction("auto-create-component-start", task.getTaskId()));
            model.add((ITemplateEvent)modelFactory.createProcessingInstruction("auto-create-component-finish", task.getTaskId()));
            if ("container".equals(creationScope)) {
                model.add(this.createContainerComponentRenderInstruction(modelFactory, task));
            }
        } else {
            if (parsePlaceholders) {
                model.insert(1, (ITemplateEvent)modelFactory.createProcessingInstruction("parse-placeholders-start", ""));
            }
            model.insert(1, (ITemplateEvent)modelFactory.createProcessingInstruction("auto-create-component-start", task.getTaskId()));
            model.insert(model.size() - 1, (ITemplateEvent)modelFactory.createProcessingInstruction("auto-create-component-finish", task.getTaskId()));
            if (createProxy) {
                model.add((ITemplateEvent)modelFactory.createProcessingInstruction("component-proxy-by-taskId", task.getTaskId()));
            }
            if (shouldRenderComponent) {
                model.insert(1, (ITemplateEvent)modelFactory.createProcessingInstruction("ignore-non-placeholders-start", ""));
                model.insert(model.size() - 1, (ITemplateEvent)modelFactory.createProcessingInstruction("ignore-non-placeholders-stop", ""));
                model.insert(model.size() - 1, (ITemplateEvent)modelFactory.createStandaloneElementTag("across:view", "element", "${@webCmsComponentAutoCreateQueue.getComponentCreated('" + task.getTaskId() + "')}"));
            }
            if ("container".equals(creationScope)) {
                model.insert(model.size() - 1, this.createContainerComponentRenderInstruction(modelFactory, task));
            }
            if (parsePlaceholders) {
                model.insert(model.size() - 1, (ITemplateEvent)modelFactory.createProcessingInstruction("parse-placeholders-stop", ""));
            }
        }
        this.attachAttributeValues(task, elementTag, expressionParser);
    }

    private void attachAttributeValues(WebCmsComponentAutoCreateTask task, IProcessableElementTag elementTag, ExpressionParser expressionParser) {
        block8: for (IAttribute attr : elementTag.getAllAttributes()) {
            String propertyName;
            int colon;
            String prefix = this.determineAttributePrefix(attr.getAttributeCompleteName());
            if (prefix == null || (colon = (propertyName = StringUtils.removeStart((String)attr.getAttributeCompleteName(), (String)prefix)).indexOf(58)) < 0) continue;
            propertyName = StringUtils.substring((String)propertyName, (int)(colon + 1));
            Object attributeValue = expressionParser.parse(attr.getValue());
            if (!StringUtils.isNotEmpty((CharSequence)propertyName)) continue;
            switch (prefix) {
                case "wcm:meta": {
                    task.addAttributeValue(WebCmsComponentAutoCreateTask.Attribute.METADATA, propertyName, attributeValue);
                    continue block8;
                }
                case "wcm:prop": {
                    task.addAttributeValue(WebCmsComponentAutoCreateTask.Attribute.PROPERTY, propertyName, attributeValue);
                    continue block8;
                }
                default: {
                    task.addAttributeValue(WebCmsComponentAutoCreateTask.Attribute.ANY, propertyName, attributeValue);
                }
            }
        }
    }

    private String determineAttributePrefix(String attributeName) {
        if (attributeName.startsWith(ATTR_META_PREFIX)) {
            return ATTR_META_PREFIX;
        }
        if (attributeName.startsWith(ATTR_PROP_PREFIX)) {
            return ATTR_PROP_PREFIX;
        }
        if (attributeName.startsWith(ATTR_ATTR_PREFIX)) {
            return ATTR_ATTR_PREFIX;
        }
        return null;
    }

    private ITemplateEvent createContainerComponentRenderInstruction(IModelFactory modelFactory, WebCmsComponentAutoCreateTask task) {
        return modelFactory.createProcessingInstruction("component-render", new WebCmsContentMarker(ATTR_COMPONENT, task.getComponentName() + "," + task.getScopeName() + ",false").toString());
    }

    private void renderEmptyBody(IModel model, IProcessableElementTag elementTag) {
        ITemplateEvent closeElementTag = null;
        if (elementTag instanceof IOpenElementTag && model.size() > 1) {
            closeElementTag = model.get(model.size() - 1);
        }
        model.reset();
        model.add((ITemplateEvent)elementTag);
        if (closeElementTag != null) {
            model.add(closeElementTag);
        }
    }

    private IProcessableElementTag renderComponentModel(IEngineContext context, IModel model, IProcessableElementTag elementTag, IModelFactory modelFactory, WebCmsComponentModel component, boolean parsePlaceholders, boolean renderComponentOutput, boolean signalProxyCreation) {
        if (parsePlaceholders) {
            model.insert(1, (ITemplateEvent)modelFactory.createProcessingInstruction("ignore-non-placeholders-start", ""));
            model.insert(1, (ITemplateEvent)modelFactory.createProcessingInstruction("parse-placeholders-start", ""));
            if (model.get(model.size() - 1) instanceof ICloseElementTag) {
                model.remove(model.size() - 1);
            }
            model.add((ITemplateEvent)modelFactory.createProcessingInstruction("ignore-non-placeholders-stop", ""));
        } else {
            model.reset();
            if (elementTag instanceof IOpenElementTag) {
                model.add((ITemplateEvent)elementTag);
            } else {
                model.add((ITemplateEvent)modelFactory.createOpenElementTag(elementTag.getElementCompleteName(), elementTag.getAttributeMap(), AttributeValueQuotes.DOUBLE, false));
                elementTag = (IProcessableElementTag)model.get(0);
            }
        }
        if (renderComponentOutput) {
            String atrId = "_generatedComponentName" + COUNTER.incrementAndGet();
            context.setVariable(atrId, (Object)component);
            model.add((ITemplateEvent)modelFactory.createStandaloneElementTag("across:view", "element", "${" + atrId + "}"));
        }
        if (signalProxyCreation) {
            model.add((ITemplateEvent)modelFactory.createProcessingInstruction("component-proxy-by-componentId", component.getObjectId()));
        }
        if (parsePlaceholders) {
            model.add((ITemplateEvent)modelFactory.createProcessingInstruction("parse-placeholders-stop", ""));
        }
        model.add((ITemplateEvent)modelFactory.createCloseElementTag(elementTag.getElementCompleteName()));
        return elementTag;
    }

    private ComponentModelLookup lookupWebComponentModel(String componentName, IProcessableElementTag elementTag, WebCmsComponentModelHierarchy components, String scopeName) {
        if ("container".equals(scopeName)) {
            return null;
        }
        IAttribute searchParentsAttribute = elementTag.getAttribute(ATTR_SEARCH_PARENTS);
        boolean searchParentScopes = scopeName == null ? searchParentsAttribute == null || !"false".equalsIgnoreCase(searchParentsAttribute.getValue()) : searchParentsAttribute != null && !"false".equalsIgnoreCase(searchParentsAttribute.getValue());
        return new ComponentModelLookup(componentName, scopeName != null ? scopeName : "default", searchParentScopes, scopeName != null ? components.getFromScope(componentName, scopeName, searchParentScopes) : components.get(componentName, searchParentScopes));
    }

    private void removeProcessedAttributesFromTag(IModel model, IProcessableElementTag elementTag, IModelFactory modelFactory) {
        IProcessableElementTag newFirstEvent = elementTag;
        for (String attributeToRemove : FIXED_ATTRIBUTES_TO_REMOVE) {
            newFirstEvent = modelFactory.removeAttribute(newFirstEvent, attributeToRemove);
        }
        for (IAttribute attr : elementTag.getAllAttributes()) {
            if (!StringUtils.startsWithAny((CharSequence)attr.getAttributeCompleteName(), (CharSequence[])new CharSequence[]{ATTR_META_PREFIX, ATTR_PROP_PREFIX, ATTR_ATTR_PREFIX})) continue;
            newFirstEvent = modelFactory.removeAttribute(newFirstEvent, attr.getAttributeCompleteName());
        }
        if (newFirstEvent != elementTag) {
            model.replace(0, (ITemplateEvent)newFirstEvent);
        }
    }

    private static class ComponentModelLookup {
        private final String componentName;
        private final String scopeName;
        private final boolean searchParents;
        private final WebCmsComponentModel componentModel;

        boolean hasComponentModel() {
            return this.componentModel != null;
        }

        public String toString() {
            return new WebCmsContentMarker(ComponentAttributeProcessor.ATTR_COMPONENT, this.componentName + "," + this.scopeName + "," + this.searchParents).toString();
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getScopeName() {
            return this.scopeName;
        }

        public boolean isSearchParents() {
            return this.searchParents;
        }

        public WebCmsComponentModel getComponentModel() {
            return this.componentModel;
        }

        public ComponentModelLookup(String componentName, String scopeName, boolean searchParents, WebCmsComponentModel componentModel) {
            this.componentName = componentName;
            this.scopeName = scopeName;
            this.searchParents = searchParents;
            this.componentModel = componentModel;
        }
    }
}

