/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateQueue;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateTask;
import com.foreach.across.modules.webcms.web.thymeleaf.ModelProcessingState;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import org.apache.commons.lang3.StringUtils;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.OutputTemplateHandler;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessingInstruction;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEnd;
import org.thymeleaf.model.ITemplateStart;
import org.thymeleaf.model.IText;
import org.thymeleaf.model.IXMLDeclaration;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.templatemode.TemplateMode;

final class ComponentAttributeTemplatePostProcessor
implements IPostProcessor {
    static final String START_ATTRIBUTE = "render-to-attribute-start";
    static final String STOP_ATTRIBUTE = "render-to-attribute-finish";

    ComponentAttributeTemplatePostProcessor() {
    }

    public TemplateMode getTemplateMode() {
        return TemplateMode.HTML;
    }

    public int getPrecedence() {
        return 0x7FFFFFFC;
    }

    public Class<? extends ITemplateHandler> getHandlerClass() {
        return TemplateHandler.class;
    }

    public static class TemplateHandler
    implements ITemplateHandler {
        private ITemplateHandler next;
        private ITemplateHandler outputHandler;
        private boolean buildingAttribute = false;
        private AttributeValue attributeValue;
        private final ArrayDeque<AttributeValue> tree = new ArrayDeque();
        private ModelProcessingState modelProcessingState;
        private WebCmsComponentAutoCreateQueue autoCreateQueue;
        private int level = 0;

        public void setNext(ITemplateHandler next) {
            this.next = next;
            this.outputHandler = next;
        }

        public void setContext(ITemplateContext context) {
            this.modelProcessingState = ModelProcessingState.retrieve(context);
            this.autoCreateQueue = this.modelProcessingState.getAutoCreateQueue();
        }

        public void handleTemplateStart(ITemplateStart templateStart) {
            this.next.handleTemplateStart(templateStart);
        }

        public void handleTemplateEnd(ITemplateEnd templateEnd) {
            this.next.handleTemplateEnd(templateEnd);
        }

        public void handleXMLDeclaration(IXMLDeclaration xmlDeclaration) {
            this.next.handleXMLDeclaration(xmlDeclaration);
        }

        public void handleDocType(IDocType docType) {
            this.next.handleDocType(docType);
        }

        public void handleCDATASection(ICDATASection cdataSection) {
            this.next.handleCDATASection(cdataSection);
        }

        public void handleComment(IComment comment) {
            this.next.handleComment(comment);
        }

        public void handleText(IText text) {
            this.next.handleText(text);
        }

        public void handleStandaloneElement(IStandaloneElementTag standaloneElementTag) {
            this.next.handleStandaloneElement(standaloneElementTag);
        }

        public void handleOpenElement(IOpenElementTag openElementTag) {
            this.next.handleOpenElement(openElementTag);
        }

        public void handleCloseElement(ICloseElementTag closeElementTag) {
            this.next.handleCloseElement(closeElementTag);
        }

        public void handleProcessingInstruction(IProcessingInstruction processingInstruction) {
            if (ComponentAttributeTemplatePostProcessor.START_ATTRIBUTE.equals(processingInstruction.getTarget())) {
                this.attributeValue = AttributeValue.from(processingInstruction.getContent());
                this.tree.push(this.attributeValue);
                this.buildingAttribute = true;
                this.next = this.attributeValue.handler;
            } else if (ComponentAttributeTemplatePostProcessor.STOP_ATTRIBUTE.equals(processingInstruction.getTarget())) {
                AttributeValue attributeValue = this.tree.pop();
                this.applyAttributeValue(this.autoCreateQueue, attributeValue);
                this.attributeValue = this.tree.peek();
                this.buildingAttribute = this.attributeValue != null;
                this.next = this.buildingAttribute ? attributeValue.handler : this.outputHandler;
            } else {
                this.next.handleProcessingInstruction(processingInstruction);
            }
        }

        private void applyAttributeValue(WebCmsComponentAutoCreateQueue autoCreateQueue, AttributeValue attributeValue) {
            WebCmsComponentAutoCreateTask currentTask = autoCreateQueue.getCurrentTask();
            if (currentTask != null) {
                currentTask.addAttributeValue(attributeValue.attributeType, attributeValue.attributeName, attributeValue.buffer.toString());
            }
        }

        private static class AttributeValue {
            private final WebCmsComponentAutoCreateTask.Attribute attributeType;
            private final String attributeName;
            private final StringWriter buffer = new StringWriter(1024);
            private final ITemplateHandler handler = new OutputTemplateHandler((Writer)this.buffer);

            public static AttributeValue from(String typeAndName) {
                int splitPos = StringUtils.indexOf((CharSequence)typeAndName, (CharSequence)":");
                return new AttributeValue(WebCmsComponentAutoCreateTask.Attribute.valueOf(typeAndName.substring(0, splitPos)), typeAndName.substring(splitPos + 1));
            }

            public AttributeValue(WebCmsComponentAutoCreateTask.Attribute attributeType, String attributeName) {
                this.attributeType = attributeType;
                this.attributeName = attributeName;
            }
        }
    }
}

