/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.AbstractElementModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

final class ComponentElementProcessor
extends AbstractElementModelProcessor {
    private static String[] ATTRIBUTES_TO_PREFIX = new String[]{"search-parent-scopes", "type", "always-replace", "parse-placeholders", "auto-create", "scope", "parent-create-include"};

    ComponentElementProcessor() {
        super(TemplateMode.HTML, "wcm", "component", true, null, false, 0);
    }

    protected void doProcess(ITemplateContext context, IModel model, IElementModelStructureHandler structureHandler) {
        IModelFactory modelFactory = context.getModelFactory();
        IProcessableElementTag openTag = (IProcessableElementTag)model.get(0);
        boolean selfClosing = openTag instanceof IStandaloneElementTag;
        Map<String, String> convertedAttributes = ComponentElementProcessor.convertAttributes(openTag.getAttributeMap());
        IOpenElementTag replacementTag = selfClosing ? modelFactory.createStandaloneElementTag("th:block", convertedAttributes, AttributeValueQuotes.DOUBLE, false, ((IStandaloneElementTag)openTag).isMinimized()) : modelFactory.createOpenElementTag("th:block", convertedAttributes, AttributeValueQuotes.DOUBLE, false);
        model.replace(0, (ITemplateEvent)replacementTag);
        if (!selfClosing) {
            model.replace(model.size() - 1, (ITemplateEvent)modelFactory.createCloseElementTag("th:block"));
        }
    }

    private static Map<String, String> convertAttributes(Map<String, String> attributeMap) {
        HashMap<String, String> converted = new HashMap<String, String>(attributeMap.size());
        attributeMap.forEach((name, value) -> {
            if (name.contains(":")) {
                converted.put((String)name, (String)value);
            } else if ("name".equals(name)) {
                converted.put("wcm:component", (String)value);
            } else if (ArrayUtils.contains((Object[])ATTRIBUTES_TO_PREFIX, (Object)name)) {
                converted.put("wcm:" + name, (String)value);
            } else {
                converted.put("wcm:attr:" + name, (String)value);
            }
        });
        return converted;
    }
}

