/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateQueue;
import com.foreach.across.modules.webcms.web.thymeleaf.ModelProcessingState;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.OutputTemplateHandler;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessingInstruction;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEnd;
import org.thymeleaf.model.ITemplateStart;
import org.thymeleaf.model.IText;
import org.thymeleaf.model.IXMLDeclaration;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.templatemode.TemplateMode;

final class ComponentTemplatePostProcessor
implements IPostProcessor {
    static final String START_INSTRUCTION = "auto-create-component-start";
    static final String STOP_INSTRUCTION = "auto-create-component-finish";
    static final String COMPONENT_RENDER = "component-render";
    static final String EXISTING_COMPONENT_PROXY = "component-proxy-by-componentId";
    static final String CREATED_COMPONENT_PROXY = "component-proxy-by-taskId";

    ComponentTemplatePostProcessor() {
    }

    public TemplateMode getTemplateMode() {
        return TemplateMode.HTML;
    }

    public int getPrecedence() {
        return 0x7FFFFFFD;
    }

    public Class<? extends ITemplateHandler> getHandlerClass() {
        return TemplateHandler.class;
    }

    public static class TemplateHandler
    implements ITemplateHandler {
        private ITemplateHandler next;
        private IModelFactory modelFactory;
        private boolean componentInCreation = false;
        private Output output;
        private ArrayDeque<Output> tree = new ArrayDeque();
        private ModelProcessingState modelProcessingState;
        private WebCmsComponentAutoCreateQueue autoCreateQueue;

        public void setNext(ITemplateHandler next) {
            this.next = next;
        }

        public void setContext(ITemplateContext context) {
            this.modelFactory = context.getModelFactory();
            this.modelProcessingState = ModelProcessingState.retrieve(context);
            this.autoCreateQueue = this.modelProcessingState.getAutoCreateQueue();
        }

        public void handleTemplateStart(ITemplateStart templateStart) {
            this.next.handleTemplateStart(templateStart);
        }

        public void handleTemplateEnd(ITemplateEnd templateEnd) {
            this.next.handleTemplateEnd(templateEnd);
        }

        public void handleXMLDeclaration(IXMLDeclaration xmlDeclaration) {
            this.next.handleXMLDeclaration(xmlDeclaration);
            if (this.componentInCreation) {
                this.output.handler.handleXMLDeclaration(xmlDeclaration);
            }
        }

        public void handleDocType(IDocType docType) {
            this.next.handleDocType(docType);
            if (this.componentInCreation) {
                this.output.handler.handleDocType(docType);
            }
        }

        public void handleCDATASection(ICDATASection cdataSection) {
            this.next.handleCDATASection(cdataSection);
            if (this.componentInCreation) {
                this.output.handler.handleCDATASection(cdataSection);
            }
        }

        public void handleComment(IComment comment) {
            this.next.handleComment(comment);
            if (this.componentInCreation) {
                this.output.handler.handleComment(comment);
            }
        }

        public void handleText(IText text) {
            this.next.handleText(text);
            if (this.componentInCreation) {
                this.output.handler.handleText(text);
            }
        }

        public void handleStandaloneElement(IStandaloneElementTag standaloneElementTag) {
            this.next.handleStandaloneElement(standaloneElementTag);
            if (this.componentInCreation) {
                this.output.handler.handleStandaloneElement(standaloneElementTag);
            }
        }

        public void handleOpenElement(IOpenElementTag openElementTag) {
            this.next.handleOpenElement(openElementTag);
            if (this.componentInCreation) {
                this.output.handler.handleOpenElement(openElementTag);
            }
        }

        public void handleCloseElement(ICloseElementTag closeElementTag) {
            this.next.handleCloseElement(closeElementTag);
            if (this.componentInCreation) {
                this.output.handler.handleCloseElement(closeElementTag);
            }
        }

        public void handleProcessingInstruction(IProcessingInstruction processingInstruction) {
            if (ComponentTemplatePostProcessor.COMPONENT_RENDER.equals(processingInstruction.getTarget())) {
                if (this.componentInCreation) {
                    this.output.handler.handleText(this.modelFactory.createText((CharSequence)processingInstruction.getContent()));
                }
            } else if (ComponentTemplatePostProcessor.EXISTING_COMPONENT_PROXY.equals(processingInstruction.getTarget())) {
                this.autoCreateQueue.createProxy(processingInstruction.getContent());
            } else if (ComponentTemplatePostProcessor.CREATED_COMPONENT_PROXY.equals(processingInstruction.getTarget())) {
                WebCmsComponentModel componentCreated = this.autoCreateQueue.getComponentCreated(processingInstruction.getContent());
                if (componentCreated != null) {
                    this.autoCreateQueue.createProxy(componentCreated.getObjectId());
                }
            } else if (ComponentTemplatePostProcessor.START_INSTRUCTION.equals(processingInstruction.getTarget())) {
                this.autoCreateQueue.outputStarted(processingInstruction.getContent());
                this.output = new Output();
                this.tree.push(this.output);
                this.componentInCreation = true;
                this.modelProcessingState.push(ModelProcessingState.Change.component());
            } else if (ComponentTemplatePostProcessor.STOP_INSTRUCTION.equals(processingInstruction.getTarget())) {
                this.autoCreateQueue.outputFinished(processingInstruction.getContent(), this.tree.pop().buffer.toString());
                this.output = this.tree.peek();
                this.componentInCreation = this.output != null;
                this.modelProcessingState.pop();
            } else if ("render-to-placeholder-start".equals(processingInstruction.getTarget()) && this.componentInCreation) {
                this.output = new Output();
                this.tree.push(this.output);
                this.componentInCreation = true;
                this.next.handleProcessingInstruction(processingInstruction);
            } else if ("render-to-placeholder-finish".equals(processingInstruction.getTarget())) {
                this.autoCreateQueue.placeholderRendered(processingInstruction.getContent());
                if (this.componentInCreation) {
                    this.tree.pop();
                    this.output = this.tree.peek();
                    boolean bl = this.componentInCreation = this.output != null;
                    if (this.componentInCreation) {
                        this.output.handler.handleText(this.modelFactory.createText((CharSequence)("@@wcm:placeholder(" + processingInstruction.getContent() + ")@@")));
                    }
                }
                this.next.handleProcessingInstruction(processingInstruction);
            } else {
                this.next.handleProcessingInstruction(processingInstruction);
            }
        }

        private static class Output {
            private StringWriter buffer = new StringWriter(1024);
            private OutputTemplateHandler handler = new OutputTemplateHandler((Writer)this.buffer);

            private Output() {
            }
        }
    }
}

