/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelHierarchy;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateQueue;
import com.foreach.across.modules.webcms.domain.component.placeholder.WebCmsPlaceholderContentModel;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.WebEngineContext;

class ModelProcessingState {
    private final WebCmsComponentModelHierarchy componentModelHierarchy;
    private final WebCmsComponentAutoCreateQueue autoCreateQueue;
    private final WebCmsPlaceholderContentModel placeholderContentModel;
    private final Deque<Change> stateChanges = new ArrayDeque<Change>();
    private Change currentState = new Change(false, false, false);

    public boolean isInsidePlaceholder() {
        return this.currentState.placeholder;
    }

    public boolean isInsideComponentBeingCreated() {
        return this.currentState.component;
    }

    public boolean isParsingPlaceholders() {
        return this.currentState.parsePlaceholders;
    }

    boolean isParsePlaceholdersOnly() {
        return this.isParsingPlaceholders() && !this.isInsidePlaceholder() && !this.isInsideComponentBeingCreated();
    }

    public void push(Change change) {
        if (change.parsePlaceholders) {
            Change change2 = change;
            change2.component = change2.component | this.currentState.component;
        }
        this.stateChanges.add(this.currentState);
        this.currentState = change;
    }

    public void pop() {
        if (!this.stateChanges.isEmpty()) {
            this.currentState = this.stateChanges.removeLast();
        }
    }

    static ModelProcessingState retrieve(ITemplateContext templateContext) {
        WebEngineContext context = (WebEngineContext)templateContext;
        HttpServletRequest request = context.getRequest();
        ModelProcessingState value = (ModelProcessingState)request.getAttribute(ModelProcessingState.class.getName());
        if (value == null) {
            WebApplicationContext applicationContext = RequestContextUtils.findWebApplicationContext((HttpServletRequest)context.getRequest());
            value = new ModelProcessingState((WebCmsComponentModelHierarchy)applicationContext.getBean(WebCmsComponentModelHierarchy.class), (WebCmsComponentAutoCreateQueue)applicationContext.getBean(WebCmsComponentAutoCreateQueue.class), (WebCmsPlaceholderContentModel)applicationContext.getBean(WebCmsPlaceholderContentModel.class));
            request.setAttribute(ModelProcessingState.class.getName(), (Object)value);
        }
        return value;
    }

    public Deque<Change> getStateChanges() {
        return this.stateChanges;
    }

    public Change getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(Change currentState) {
        this.currentState = currentState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelProcessingState)) {
            return false;
        }
        ModelProcessingState other = (ModelProcessingState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WebCmsComponentModelHierarchy this$componentModelHierarchy = this.getComponentModelHierarchy();
        WebCmsComponentModelHierarchy other$componentModelHierarchy = other.getComponentModelHierarchy();
        if (this$componentModelHierarchy == null ? other$componentModelHierarchy != null : !this$componentModelHierarchy.equals(other$componentModelHierarchy)) {
            return false;
        }
        WebCmsComponentAutoCreateQueue this$autoCreateQueue = this.getAutoCreateQueue();
        WebCmsComponentAutoCreateQueue other$autoCreateQueue = other.getAutoCreateQueue();
        if (this$autoCreateQueue == null ? other$autoCreateQueue != null : !this$autoCreateQueue.equals(other$autoCreateQueue)) {
            return false;
        }
        WebCmsPlaceholderContentModel this$placeholderContentModel = this.getPlaceholderContentModel();
        WebCmsPlaceholderContentModel other$placeholderContentModel = other.getPlaceholderContentModel();
        if (this$placeholderContentModel == null ? other$placeholderContentModel != null : !this$placeholderContentModel.equals(other$placeholderContentModel)) {
            return false;
        }
        Deque<Change> this$stateChanges = this.getStateChanges();
        Deque<Change> other$stateChanges = other.getStateChanges();
        if (this$stateChanges == null ? other$stateChanges != null : !this$stateChanges.equals(other$stateChanges)) {
            return false;
        }
        Change this$currentState = this.getCurrentState();
        Change other$currentState = other.getCurrentState();
        return !(this$currentState == null ? other$currentState != null : !((Object)this$currentState).equals(other$currentState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelProcessingState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebCmsComponentModelHierarchy $componentModelHierarchy = this.getComponentModelHierarchy();
        result = result * 59 + ($componentModelHierarchy == null ? 43 : $componentModelHierarchy.hashCode());
        WebCmsComponentAutoCreateQueue $autoCreateQueue = this.getAutoCreateQueue();
        result = result * 59 + ($autoCreateQueue == null ? 43 : $autoCreateQueue.hashCode());
        WebCmsPlaceholderContentModel $placeholderContentModel = this.getPlaceholderContentModel();
        result = result * 59 + ($placeholderContentModel == null ? 43 : $placeholderContentModel.hashCode());
        Deque<Change> $stateChanges = this.getStateChanges();
        result = result * 59 + ($stateChanges == null ? 43 : $stateChanges.hashCode());
        Change $currentState = this.getCurrentState();
        result = result * 59 + ($currentState == null ? 43 : ((Object)$currentState).hashCode());
        return result;
    }

    public String toString() {
        return "ModelProcessingState(componentModelHierarchy=" + this.getComponentModelHierarchy() + ", autoCreateQueue=" + this.getAutoCreateQueue() + ", placeholderContentModel=" + this.getPlaceholderContentModel() + ", stateChanges=" + this.getStateChanges() + ", currentState=" + this.getCurrentState() + ")";
    }

    private ModelProcessingState(WebCmsComponentModelHierarchy componentModelHierarchy, WebCmsComponentAutoCreateQueue autoCreateQueue, WebCmsPlaceholderContentModel placeholderContentModel) {
        this.componentModelHierarchy = componentModelHierarchy;
        this.autoCreateQueue = autoCreateQueue;
        this.placeholderContentModel = placeholderContentModel;
    }

    public WebCmsComponentModelHierarchy getComponentModelHierarchy() {
        return this.componentModelHierarchy;
    }

    public WebCmsComponentAutoCreateQueue getAutoCreateQueue() {
        return this.autoCreateQueue;
    }

    public WebCmsPlaceholderContentModel getPlaceholderContentModel() {
        return this.placeholderContentModel;
    }

    static class Change {
        private boolean placeholder;
        private boolean component;
        private boolean parsePlaceholders;

        static Change placeholder() {
            return new Change(true, false, false);
        }

        static Change component() {
            return new Change(false, true, false);
        }

        static Change parsePlaceholders() {
            return new Change(false, false, true);
        }

        public boolean isPlaceholder() {
            return this.placeholder;
        }

        public boolean isComponent() {
            return this.component;
        }

        public boolean isParsePlaceholders() {
            return this.parsePlaceholders;
        }

        public void setPlaceholder(boolean placeholder) {
            this.placeholder = placeholder;
        }

        public void setComponent(boolean component) {
            this.component = component;
        }

        public void setParsePlaceholders(boolean parsePlaceholders) {
            this.parsePlaceholders = parsePlaceholders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Change)) {
                return false;
            }
            Change other = (Change)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPlaceholder() != other.isPlaceholder()) {
                return false;
            }
            if (this.isComponent() != other.isComponent()) {
                return false;
            }
            return this.isParsePlaceholders() == other.isParsePlaceholders();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Change;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPlaceholder() ? 79 : 97);
            result = result * 59 + (this.isComponent() ? 79 : 97);
            result = result * 59 + (this.isParsePlaceholders() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ModelProcessingState.Change(placeholder=" + this.isPlaceholder() + ", component=" + this.isComponent() + ", parsePlaceholders=" + this.isParsePlaceholders() + ")";
        }

        public Change(boolean placeholder, boolean component, boolean parsePlaceholders) {
            this.placeholder = placeholder;
            this.component = component;
            this.parsePlaceholders = parsePlaceholders;
        }
    }
}

