/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.modules.webcms.web.thymeleaf.ModelProcessingState;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.AbstractAttributeModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

final class PlaceholderAttributeProcessor
extends AbstractAttributeModelProcessor {
    PlaceholderAttributeProcessor() {
        super(TemplateMode.HTML, "wcm", null, false, "placeholder", true, 99, false);
    }

    protected void doProcess(ITemplateContext context, IModel model, AttributeName attributeName, String placeholderName, IElementModelStructureHandler structureHandler) {
        if (model.size() > 0 && model.get(0) instanceof IProcessableElementTag) {
            IProcessableElementTag elementTag = (IProcessableElementTag)model.get(0);
            IModelFactory modelFactory = context.getModelFactory();
            if (placeholderName != null) {
                ModelProcessingState modelProcessingState = ModelProcessingState.retrieve(context);
                boolean shouldRenderToPlaceholder = !this.shouldIncludeInOutputDirectly(elementTag, modelProcessingState);
                this.removeProcessedAttributes(model, attributeName, modelFactory);
                if (shouldRenderToPlaceholder) {
                    model.insert(0, (ITemplateEvent)modelFactory.createProcessingInstruction("render-to-placeholder-start", placeholderName));
                    model.add((ITemplateEvent)modelFactory.createProcessingInstruction("render-to-placeholder-finish", placeholderName));
                }
            }
        }
    }

    private boolean shouldIncludeInOutputDirectly(IProcessableElementTag tag, ModelProcessingState modelProcessingState) {
        return !modelProcessingState.isParsePlaceholdersOnly() && tag.hasAttribute("wcm:parent-create-include");
    }

    private void removeProcessedAttributes(IModel model, AttributeName attributeName, IModelFactory modelFactory) {
        IProcessableElementTag elementTag = (IProcessableElementTag)model.get(0);
        IProcessableElementTag newFirstEvent = modelFactory.removeAttribute(elementTag, attributeName);
        if ((newFirstEvent = modelFactory.removeAttribute(newFirstEvent, "wcm:parent-create-include")) != elementTag) {
            model.replace(0, (ITemplateEvent)newFirstEvent);
        }
    }
}

