/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.modules.webcms.domain.component.placeholder.WebCmsPlaceholderContentModel;
import com.foreach.across.modules.webcms.web.thymeleaf.ModelProcessingState;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AbstractTemplateHandler;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.OutputTemplateHandler;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessingInstruction;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEnd;
import org.thymeleaf.model.ITemplateStart;
import org.thymeleaf.model.IText;
import org.thymeleaf.model.IXMLDeclaration;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.templatemode.TemplateMode;

final class PlaceholderTemplatePostProcessor
implements IPostProcessor {
    static final String START_PLACEHOLDER = "render-to-placeholder-start";
    static final String STOP_PLACEHOLDER = "render-to-placeholder-finish";
    static final String START_PARSE_PLACEHOLDERS = "parse-placeholders-start";
    static final String STOP_PARSE_PLACEHOLDERS = "parse-placeholders-stop";
    static final String START_IGNORE_NON_PLACEHOLDERS = "ignore-non-placeholders-start";
    static final String STOP_IGNORE_NON_PLACEHOLDERS = "ignore-non-placeholders-stop";

    PlaceholderTemplatePostProcessor() {
    }

    public TemplateMode getTemplateMode() {
        return TemplateMode.HTML;
    }

    public int getPrecedence() {
        return 0x7FFFFFFE;
    }

    public Class<? extends ITemplateHandler> getHandlerClass() {
        return TemplateHandler.class;
    }

    public static class TemplateHandler
    implements ITemplateHandler {
        private final ITemplateHandler trashHandler = new AbstractTemplateHandler(){};
        private ITemplateHandler next;
        private ITemplateHandler outputHandler;
        private boolean buildingPlaceholderContent = false;
        private PlaceholderContent placeholderContent;
        private final ArrayDeque<PlaceholderContent> tree = new ArrayDeque();
        private ModelProcessingState modelProcessingState;
        private WebCmsPlaceholderContentModel placeholderContentModel;
        private int level = 0;
        private int trashLevel = 0;

        public void setNext(ITemplateHandler next) {
            this.next = next;
            this.outputHandler = next;
        }

        public void setContext(ITemplateContext context) {
            this.modelProcessingState = ModelProcessingState.retrieve(context);
            this.placeholderContentModel = this.modelProcessingState.getPlaceholderContentModel();
        }

        public void handleTemplateStart(ITemplateStart templateStart) {
            this.next.handleTemplateStart(templateStart);
        }

        public void handleTemplateEnd(ITemplateEnd templateEnd) {
            this.next.handleTemplateEnd(templateEnd);
        }

        public void handleXMLDeclaration(IXMLDeclaration xmlDeclaration) {
            this.next.handleXMLDeclaration(xmlDeclaration);
        }

        public void handleDocType(IDocType docType) {
            this.next.handleDocType(docType);
        }

        public void handleCDATASection(ICDATASection cdataSection) {
            this.next.handleCDATASection(cdataSection);
        }

        public void handleComment(IComment comment) {
            this.next.handleComment(comment);
        }

        public void handleText(IText text) {
            this.next.handleText(text);
        }

        public void handleStandaloneElement(IStandaloneElementTag standaloneElementTag) {
            this.next.handleStandaloneElement(standaloneElementTag);
        }

        public void handleOpenElement(IOpenElementTag openElementTag) {
            this.next.handleOpenElement(openElementTag);
        }

        public void handleCloseElement(ICloseElementTag closeElementTag) {
            this.next.handleCloseElement(closeElementTag);
        }

        public void handleProcessingInstruction(IProcessingInstruction processingInstruction) {
            if (PlaceholderTemplatePostProcessor.START_PLACEHOLDER.equals(processingInstruction.getTarget()) && this.parsing()) {
                this.placeholderContent = new PlaceholderContent(processingInstruction.getContent());
                this.tree.push(this.placeholderContent);
                this.modelProcessingState.push(ModelProcessingState.Change.placeholder());
                this.buildingPlaceholderContent = true;
                this.next = this.placeholderContent.handler;
            } else if (PlaceholderTemplatePostProcessor.STOP_PLACEHOLDER.equals(processingInstruction.getTarget()) && this.parsing()) {
                PlaceholderContent placeholderContent = this.tree.pop();
                this.placeholderContentModel.setPlaceholderContent(placeholderContent.placeholder, placeholderContent.buffer.toString());
                this.placeholderContent = this.tree.peek();
                this.buildingPlaceholderContent = this.placeholderContent != null;
                this.modelProcessingState.pop();
                this.next = this.buildingPlaceholderContent ? placeholderContent.handler : (this.allowNonPlaceholderOutput() ? this.outputHandler : this.trashHandler);
            } else if (PlaceholderTemplatePostProcessor.START_PARSE_PLACEHOLDERS.equals(processingInstruction.getTarget())) {
                ++this.level;
                this.placeholderContentModel.increaseLevel();
                this.modelProcessingState.push(ModelProcessingState.Change.parsePlaceholders());
            } else if (PlaceholderTemplatePostProcessor.STOP_PARSE_PLACEHOLDERS.equals(processingInstruction.getTarget())) {
                this.level = Math.max(this.level - 1, 0);
                this.placeholderContentModel.decreaseLevel();
                this.modelProcessingState.pop();
            } else if (PlaceholderTemplatePostProcessor.START_IGNORE_NON_PLACEHOLDERS.equals(processingInstruction.getTarget())) {
                ++this.trashLevel;
                if (!this.buildingPlaceholderContent) {
                    this.next = this.trashHandler;
                }
            } else if (PlaceholderTemplatePostProcessor.STOP_IGNORE_NON_PLACEHOLDERS.equals(processingInstruction.getTarget())) {
                this.trashLevel = Math.max(this.trashLevel - 1, 0);
                if (this.trashLevel == 0) {
                    this.next = this.outputHandler;
                }
            } else if (!"component-render".equals(processingInstruction.getTarget())) {
                this.next.handleProcessingInstruction(processingInstruction);
            }
        }

        private boolean allowNonPlaceholderOutput() {
            return this.trashLevel == 0;
        }

        private boolean parsing() {
            return this.level > 0;
        }

        private static class PlaceholderContent {
            private final String placeholder;
            private final StringWriter buffer = new StringWriter(1024);
            private final ITemplateHandler handler = new OutputTemplateHandler((Writer)this.buffer);

            public PlaceholderContent(String placeholder) {
                this.placeholder = placeholder;
            }
        }
    }
}

