/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.webcms.domain.component.WebCmsContentMarker;
import com.foreach.across.modules.webcms.domain.component.WebCmsContentMarkerService;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.web.thymeleaf.WebCmsComponentContentMarkerRenderer;
import java.util.Collection;
import java.util.regex.Matcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Exposed
@Component
public final class WebCmsComponentContentModelWriter {
    private final WebCmsComponentContentMarkerRenderer KEEP_MARKER = new WebCmsComponentContentMarkerRenderer(){

        @Override
        public boolean supports(WebCmsComponentModel componentModel, WebCmsContentMarker marker) {
            return false;
        }

        public void writeMarkerOutput(WebCmsComponentModel component, WebCmsContentMarker marker, ThymeleafModelBuilder model) {
            model.addText(marker.toString());
        }
    };
    private Collection<WebCmsComponentContentMarkerRenderer> renderers;

    public void writeText(WebCmsComponentModel componentModel, String text, boolean parseMarkers, ThymeleafModelBuilder model) {
        this.writeText(componentModel, text, true, parseMarkers, model);
    }

    public void writeHtml(WebCmsComponentModel componentModel, String text, boolean parseMarkers, ThymeleafModelBuilder model) {
        this.writeText(componentModel, text, false, parseMarkers, model);
    }

    public void writeText(WebCmsComponentModel componentModel, String text, boolean escapeXml, boolean parseMarkers, ThymeleafModelBuilder model) {
        if (parseMarkers) {
            Matcher matcher = WebCmsContentMarkerService.MARKER_PATTERN.matcher(text);
            int start = 0;
            while (matcher.find()) {
                model.addText(text.substring(start, matcher.start()), escapeXml);
                this.writeMarker(componentModel, WebCmsContentMarker.fromMarkerString(matcher.group()), model);
                start = matcher.end();
            }
            model.addText(text.substring(start), escapeXml);
        } else {
            model.addText(text, escapeXml);
        }
    }

    private void writeMarker(WebCmsComponentModel componentModel, WebCmsContentMarker contentMarker, ThymeleafModelBuilder model) {
        this.renderers.stream().filter(r -> r.supports(componentModel, contentMarker)).findFirst().orElse(this.KEEP_MARKER).writeMarkerOutput(componentModel, contentMarker, model);
    }

    @Autowired
    void setRenderers(@RefreshableCollection(includeModuleInternals=true) Collection<WebCmsComponentContentMarkerRenderer> renderers) {
        this.renderers = renderers;
    }
}

