/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.web.thymeleaf;

import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.web.ui.thymeleaf.ViewElementModelWriter;
import com.foreach.across.modules.web.ui.thymeleaf.ViewElementModelWriterRegistry;
import com.foreach.across.modules.webcms.domain.component.UnknownWebCmsComponentModelException;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.web.thymeleaf.WebCmsComponentModelRenderer;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@ConditionalOnBean(value={ViewElementModelWriterRegistry.class})
@Component
class WebCmsComponentModelViewElementModelWriter
implements ViewElementModelWriter<WebCmsComponentModel> {
    private Collection<WebCmsComponentModelRenderer> renderers;

    WebCmsComponentModelViewElementModelWriter() {
    }

    public void writeModel(WebCmsComponentModel webComponentModel, ThymeleafModelBuilder model) {
        this.renderers.stream().filter(r -> r.supports(webComponentModel)).findFirst().orElseThrow(() -> new UnknownWebCmsComponentModelException(webComponentModel)).writeComponent(webComponentModel, model);
    }

    @Autowired
    void setRenderers(@RefreshableCollection(includeModuleInternals=true) Collection<WebCmsComponentModelRenderer> renderers) {
        this.renderers = renderers;
    }

    @Autowired
    void registerModelWriter(ViewElementModelWriterRegistry modelWriterRegistry) {
        modelWriterRegistry.registerModelWriter(WebCmsComponentModel.class.getSimpleName(), (ViewElementModelWriter)this);
    }
}

