/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.admin.controllers;

import com.foreach.across.modules.adminweb.annotations.AdminWebController;
import com.foreach.across.modules.adminweb.menu.AdminMenuEvent;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.template.ClearTemplate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.event.EventListener;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@AdminWebController
public class AdminWebAppController {
    private final String accessToken;
    private final String imageServerUrl;

    public AdminWebAppController(String imageServerUrl, String accessToken) {
        this.accessToken = accessToken;
        this.imageServerUrl = StringUtils.removeEnd((String)imageServerUrl, (String)"/");
    }

    @EventListener
    public void registerMenu(AdminMenuEvent adminMenuEvent) {
        adminMenuEvent.builder().item("/image-server", "Image server");
    }

    @ModelAttribute
    public void init(WebResourceRegistry resourceRegistry) {
        resourceRegistry.addWithKey("css", "ImageServerAdminWeb", (Object)"/css/imageserver-admin/admin.css", "views");
        resourceRegistry.addWithKey("javascript", "angular", (Object)"https://ajax.googleapis.com/ajax/libs/angularjs/1.3.0-beta.8/angular.js", "external");
        resourceRegistry.addWithKey("javascript", "angular-route", (Object)"https://ajax.googleapis.com/ajax/libs/angularjs/1.3.0-beta.8/angular-route.js", "external");
        resourceRegistry.addWithKey("javascript", "angular-file-upload", (Object)"/js/imageserver-admin/angular-file-upload.js", "views");
        resourceRegistry.addWithKey("javascript", "angular-ui-utils", (Object)"/js/imageserver-admin/ui-utils-0.1.1/ui-utils.min.js", "views");
        resourceRegistry.addWithKey("javascript", "ImageServerAdminWeb", (Object)"/js/imageserver-admin/admin-app.js", "views");
    }

    @RequestMapping(value={"/image-server"})
    public String bootstrapWebApp(Model model) {
        model.addAttribute("accessToken", (Object)this.accessToken);
        model.addAttribute("imageServerUrl", (Object)this.imageServerUrl);
        return "th/imageserver-admin/admin-app";
    }

    @RequestMapping(value={"/partial/{view}"})
    @ClearTemplate
    public String angularView(@PathVariable(value="view") String path) {
        return "th/imageserver-admin/partial/" + path;
    }

    @RequestMapping(value={"/upload"})
    public String showUpload() {
        return "th/imageserver-admin/upload";
    }

    @RequestMapping(value={"/view"})
    public String seeImage() {
        return "th/imageserver-admin/view";
    }
}

