/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.client;

import com.foreach.imageserver.client.ImageRequestHashBuilder;
import com.foreach.imageserver.client.ImageServerClient;
import com.foreach.imageserver.dto.CropDto;
import com.foreach.imageserver.dto.DimensionsDto;
import com.foreach.imageserver.dto.ImageModificationDto;
import com.foreach.imageserver.dto.ImageResolutionDto;
import com.foreach.imageserver.dto.ImageTypeDto;
import com.foreach.imageserver.dto.ImageVariantDto;
import com.foreach.imageserver.logging.LogHelper;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractImageServerClient
implements ImageServerClient {
    private ImageRequestHashBuilder hashBuilder;
    private String imageServerUrl;

    protected AbstractImageServerClient(String imageServerUrl) {
        this.imageServerUrl = imageServerUrl;
    }

    @Override
    public String getImageServerUrl() {
        return this.imageServerUrl;
    }

    public void setImageServerUrl(String imageServerUrl) {
        this.imageServerUrl = imageServerUrl;
    }

    public void setImageRequestHashBuilder(ImageRequestHashBuilder hashBuilder) {
        this.hashBuilder = hashBuilder;
    }

    protected Optional<ImageRequestHashBuilder> hashBuilder() {
        return Optional.ofNullable(this.hashBuilder);
    }

    @Override
    public String imageUrl(String imageId, String context, int width, int height) {
        return this.imageUrl(imageId, context, new ImageResolutionDto(width, height), new ImageVariantDto(), new String[0]);
    }

    @Override
    public String imageUrl(String imageId, String context, String ... size) {
        return this.imageUrl(imageId, context, null, new ImageVariantDto(), size);
    }

    @Override
    public String imageUrl(String imageId, String context, int width, int height, ImageTypeDto imageType) {
        return this.imageUrl(imageId, context, new ImageResolutionDto(width, height), new ImageVariantDto(imageType), new String[0]);
    }

    @Override
    public String imageUrl(String imageId, String context, int width, int height, ImageVariantDto imageVariant) {
        return this.imageUrl(imageId, context, new ImageResolutionDto(width, height), imageVariant, new String[0]);
    }

    @Override
    public String imageUrl(String imageId, String context, ImageTypeDto imageType, String ... size) {
        return this.imageUrl(imageId, context, null, new ImageVariantDto(imageType), size);
    }

    @Override
    public String imageUrl(String imageId, String context, ImageResolutionDto imageResolution, ImageVariantDto imageVariant, String ... size) {
        if (StringUtils.isBlank((CharSequence)imageId) || context == null || imageVariant == null) {
            LOG.warn("Null parameters not allowed - imageId={}, context={}, imageResolution={}, imageVariant={}, size={}", LogHelper.flatten(imageId, context, imageResolution, imageVariant, size));
        }
        if (imageResolution == null && (size == null || size.length == 0)) {
            LOG.error("Request does not contain an imageResolution or size - imageId={}, context={}, imageResolution={}, imageVariant={}, size={}", LogHelper.flatten(imageId, context, null, imageVariant, size));
            throw new IllegalArgumentException("Request does not contain an imageResolution or size");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"iid", (Object)imageId);
        queryParams.set((Object)"context", (Object)StringUtils.defaultString((String)context));
        if (imageResolution != null) {
            this.addQueryParams((MultiValueMap<String, String>)queryParams, imageResolution);
        }
        if (size != null && size.length > 0) {
            queryParams.set((Object)"size", (Object)StringUtils.join((Object[])size, (String)","));
        }
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageVariant);
        this.hashBuilder().ifPresent(arg_0 -> AbstractImageServerClient.lambda$imageUrl$0((MultiValueMap)queryParams, context, imageResolution, imageVariant, size, arg_0));
        return this.buildUri("view", (MultiValueMap<String, String>)queryParams).toString();
    }

    @Override
    public String imageUrl(String imageId, String context, String ratio, int screenWidth, ImageTypeDto imageType, int width, int height) {
        return this.imageUrl(imageId, context, ratio, screenWidth, new ImageVariantDto(imageType, new DimensionsDto(width, height)));
    }

    @Override
    public String imageUrl(String imageId, String context, String ratio, int screenWidth, ImageVariantDto imageVariant) {
        if (StringUtils.isBlank((CharSequence)imageId) || context == null || ratio == null || imageVariant == null) {
            LOG.warn("Null parameters not allowed -- imageId={}, context={}, ratio={}, imageVariant={}", new Object[]{imageId, context, ratio, imageVariant});
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"iid", (Object)imageId);
        queryParams.set((Object)"context", (Object)StringUtils.defaultString((String)context));
        queryParams.set((Object)"ratio", (Object)ratio);
        queryParams.set((Object)"width", (Object)Integer.toString(screenWidth));
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageVariant);
        this.hashBuilder().ifPresent(arg_0 -> AbstractImageServerClient.lambda$imageUrl$1((MultiValueMap)queryParams, context, ratio, screenWidth, imageVariant, arg_0));
        return this.buildUri("view", (MultiValueMap<String, String>)queryParams).toString();
    }

    protected URI buildUri(String path, MultiValueMap<String, String> queryParams) {
        return this.buildUri(path, queryParams, this.imageServerUrl);
    }

    protected URI buildUri(String path, MultiValueMap<String, String> queryParams, String host) {
        UriComponentsBuilder uri = UriComponentsBuilder.fromHttpUrl((String)host).path("/").path(path);
        for (String key : queryParams.keySet()) {
            for (int n = 0; n < ((List)queryParams.get((Object)key)).size(); ++n) {
                uri.queryParam(key, new Object[]{((List)queryParams.get((Object)key)).get(n)});
            }
        }
        return uri.build().toUri();
    }

    protected void addQueryParams(MultiValueMap<String, String> queryParams, ImageResolutionDto imageResolution) {
        if (imageResolution.getWidth() != 0) {
            queryParams.set((Object)"width", (Object)Integer.toString(imageResolution.getWidth()));
        }
        if (imageResolution.getHeight() != 0) {
            queryParams.set((Object)"height", (Object)Integer.toString(imageResolution.getHeight()));
        }
    }

    protected void addQueryParams(MultiValueMap<String, String> queryParams, ImageVariantDto imageVariant) {
        DimensionsDto boundaries;
        ImageTypeDto imageTypeDto = imageVariant.getImageType();
        if (imageTypeDto != null) {
            queryParams.set((Object)"imageType", (Object)imageVariant.getImageType().toString());
        }
        if ((boundaries = imageVariant.getBoundaries()) != null) {
            queryParams.set((Object)"boundaries.width", (Object)String.valueOf(boundaries.getWidth()));
            queryParams.set((Object)"boundaries.height", (Object)String.valueOf(boundaries.getHeight()));
        }
    }

    protected void addQueryParams(MultiValueMap<String, String> queryParams, ImageModificationDto imageModification) {
        ImageResolutionDto resolution = imageModification.getResolution();
        DimensionsDto boundaries = imageModification.getBoundaries();
        CropDto crop = imageModification.getCrop();
        DimensionsDto density = imageModification.getDensity();
        queryParams.add((Object)"resolution.width", (Object)Integer.toString(resolution.getWidth()));
        queryParams.add((Object)"resolution.height", (Object)Integer.toString(resolution.getHeight()));
        queryParams.add((Object)"crop.x", (Object)Integer.toString(crop.getX()));
        queryParams.add((Object)"crop.y", (Object)Integer.toString(crop.getY()));
        queryParams.add((Object)"crop.width", (Object)Integer.toString(crop.getWidth()));
        queryParams.add((Object)"crop.height", (Object)Integer.toString(crop.getHeight()));
        queryParams.add((Object)"crop.source.width", (Object)Integer.toString(crop.getSource().getWidth()));
        queryParams.add((Object)"crop.source.height", (Object)Integer.toString(crop.getSource().getHeight()));
        queryParams.add((Object)"crop.box.width", (Object)Integer.toString(crop.getBox().getWidth()));
        queryParams.add((Object)"crop.box.height", (Object)Integer.toString(crop.getBox().getHeight()));
        queryParams.add((Object)"density.width", (Object)Integer.toString(density.getWidth()));
        queryParams.add((Object)"density.height", (Object)Integer.toString(density.getHeight()));
        queryParams.add((Object)"boundaries.width", (Object)Integer.toString(boundaries.getWidth()));
        queryParams.add((Object)"boundaries.height", (Object)Integer.toString(boundaries.getHeight()));
    }

    protected void addQueryParams(MultiValueMap<String, String> queryParams, List<ImageModificationDto> imageModifications) {
        for (ImageModificationDto imageModificationDto : imageModifications) {
            this.addQueryParams(queryParams, imageModificationDto);
        }
    }

    private static /* synthetic */ void lambda$imageUrl$1(MultiValueMap queryParams, String context, String ratio, int screenWidth, ImageVariantDto imageVariant, ImageRequestHashBuilder hb) {
        queryParams.set((Object)"hash", (Object)hb.calculateHash(context, ratio, new ImageResolutionDto(screenWidth, 0), imageVariant, new String[0]));
    }

    private static /* synthetic */ void lambda$imageUrl$0(MultiValueMap queryParams, String context, ImageResolutionDto imageResolution, ImageVariantDto imageVariant, String[] size, ImageRequestHashBuilder hb) {
        queryParams.set((Object)"hash", (Object)hb.calculateHash(context, null, imageResolution, imageVariant, size));
    }
}

