/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.client;

import com.foreach.imageserver.dto.ImageConvertDto;
import com.foreach.imageserver.dto.ImageConvertResultDto;
import com.foreach.imageserver.dto.ImageDto;
import com.foreach.imageserver.dto.ImageInfoDto;
import com.foreach.imageserver.dto.ImageModificationDto;
import com.foreach.imageserver.dto.ImageResolutionDto;
import com.foreach.imageserver.dto.ImageTransformDto;
import com.foreach.imageserver.dto.ImageTypeDto;
import com.foreach.imageserver.dto.ImageVariantDto;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ImageServerClient {
    public static final Logger LOG = LoggerFactory.getLogger(ImageServerClient.class);
    public static final String ENDPOINT_IMAGE_VIEW = "view";
    public static final String ENDPOINT_IMAGE_RENDER = "api/image/render";
    public static final String ENDPOINT_IMAGE_LOAD = "api/image/load";
    public static final String ENDPOINT_IMAGE_DELETE = "api/image/delete";
    public static final String ENDPOINT_IMAGE_INFO = "api/image/details";
    public static final String ENDPOINT_IMAGE_PREGENERATE = "api/image/pregenerate";
    public static final String ENDPOINT_RESOLUTION_LIST = "api/resolution/list";
    public static final String ENDPOINT_MODIFICATION_LIST = "api/modification/list";
    public static final String ENDPOINT_MODIFICATION_REGISTER = "api/modification/register";
    public static final String ENDPOINT_MODIFICATION_REGISTER_LIST = "api/modification/registerlist";
    public static final String ENDPOINT_IMAGE_CONVERT = "api/image/convert";

    public String getImageServerUrl();

    public String imageUrl(String var1, String var2, int var3, int var4);

    public String imageUrl(String var1, String var2, String ... var3);

    public String imageUrl(String var1, String var2, int var3, int var4, ImageTypeDto var5);

    public String imageUrl(String var1, String var2, int var3, int var4, ImageVariantDto var5);

    public String imageUrl(String var1, String var2, ImageTypeDto var3, String ... var4);

    public InputStream imageStream(String var1, String var2, Integer var3, Integer var4, ImageTypeDto var5);

    public InputStream imageStream(String var1, String var2, ImageResolutionDto var3, ImageVariantDto var4);

    public String imageUrl(String var1, String var2, ImageResolutionDto var3, ImageVariantDto var4, String ... var5);

    public String imageUrl(String var1, String var2, String var3, int var4, ImageTypeDto var5, int var6, int var7);

    public String imageUrl(String var1, String var2, String var3, int var4, ImageVariantDto var5);

    public InputStream imageStream(String var1, ImageModificationDto var2, ImageVariantDto var3);

    public InputStream imageStream(byte[] var1, ImageModificationDto var2, ImageVariantDto var3);

    public ImageInfoDto loadImage(String var1, byte[] var2);

    public ImageInfoDto loadImage(String var1, byte[] var2, boolean var3);

    public ImageInfoDto loadImage(String var1, byte[] var2, Date var3);

    public ImageInfoDto loadImage(String var1, byte[] var2, Date var3, boolean var4);

    public boolean deleteImage(String var1);

    public boolean imageExists(String var1);

    public ImageInfoDto imageInfo(String var1);

    public ImageInfoDto imageInfo(byte[] var1);

    public List<ImageResolutionDto> pregenerateResolutions(String var1);

    public void registerImageModification(String var1, String var2, ImageModificationDto var3);

    public void registerImageModifications(String var1, String var2, List<ImageModificationDto> var3);

    public List<ImageModificationDto> listModifications(String var1, String var2);

    public List<ImageResolutionDto> listAllowedResolutions(String var1);

    public List<ImageResolutionDto> listConfigurableResolutions(String var1);

    default public ImageDto convertImage(byte[] imageBytes, List<ImageTransformDto> transforms) {
        return this.convertImage(ImageConvertDto.builder().image(imageBytes).transformation("transform", transforms).build()).getTransforms().get("transform");
    }

    default public ImageDto convertImage(String imageId, List<ImageTransformDto> transforms) {
        return this.convertImage(ImageConvertDto.builder().imageId(imageId).transformation("transform", transforms).build()).getTransforms().get("transform");
    }

    public ImageConvertResultDto convertImage(ImageConvertDto var1);
}

