/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.client;

import com.foreach.imageserver.client.ImageRequestHashBuilder;
import com.foreach.imageserver.dto.ImageResolutionDto;
import com.foreach.imageserver.dto.ImageVariantDto;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.DigestUtils;

public class Md5ImageRequestHashBuilder
implements ImageRequestHashBuilder {
    private final String hashToken;

    public Md5ImageRequestHashBuilder(@NonNull String hashToken) {
        if (hashToken == null) {
            throw new IllegalArgumentException("hashToken is marked non-null but is null");
        }
        this.hashToken = hashToken;
    }

    @Override
    public String calculateHash(String context, String ratio, ImageResolutionDto imageResolution, ImageVariantDto imageVariant, String ... size) {
        StringBuilder buffer = new StringBuilder(this.hashToken).append(context).append(StringUtils.defaultString((String)ratio)).append(StringUtils.join((Object[])size));
        if (imageResolution != null) {
            buffer.append("res").append(imageResolution.getWidth()).append(imageResolution.getHeight());
        } else {
            buffer.append("res");
        }
        if (imageVariant != null) {
            buffer.append("var");
            if (imageVariant.getImageType() != null) {
                buffer.append((Object)imageVariant.getImageType());
            }
            if (imageVariant.getBoundaries() != null) {
                buffer.append(imageVariant.getBoundaries().getWidth()).append(imageVariant.getBoundaries().getHeight());
            }
        } else {
            buffer.append("var");
        }
        return DigestUtils.md5DigestAsHex((byte[])buffer.toString().getBytes());
    }
}

