/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.client;

import com.foreach.imageserver.client.AbstractImageServerClient;
import com.foreach.imageserver.client.ImageRequestHashBuilder;
import com.foreach.imageserver.client.ImageServerException;
import com.foreach.imageserver.dto.ImageConvertDto;
import com.foreach.imageserver.dto.ImageConvertResultDto;
import com.foreach.imageserver.dto.ImageInfoDto;
import com.foreach.imageserver.dto.ImageModificationDto;
import com.foreach.imageserver.dto.ImageResolutionDto;
import com.foreach.imageserver.dto.ImageTypeDto;
import com.foreach.imageserver.dto.ImageVariantDto;
import com.foreach.imageserver.dto.JsonResponse;
import com.foreach.imageserver.logging.LogHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RemoteImageServerClient
extends AbstractImageServerClient {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteImageServerClient.class);
    private final String imageServerAccessToken;
    private RestTemplate restTemplate;

    public RemoteImageServerClient(String imageServerEndpoint, String imageServerAccessToken) {
        this(imageServerEndpoint, imageServerAccessToken, new RestTemplate());
    }

    public RemoteImageServerClient(String imageServerEndpoint, String imageServerAccessToken, RestTemplate restTemplate) {
        super(imageServerEndpoint);
        this.imageServerAccessToken = imageServerAccessToken;
        this.restTemplate = restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        Assert.notNull((Object)restTemplate, (String)"RestTemplate can not be null");
        this.restTemplate = restTemplate;
    }

    @Override
    public InputStream imageStream(String imageId, String context, Integer width, Integer height, ImageTypeDto imageType) {
        return this.imageStream(imageId, context, new ImageResolutionDto(width, height), new ImageVariantDto(imageType));
    }

    @Override
    public InputStream imageStream(String imageId, String context, ImageResolutionDto imageResolution, ImageVariantDto imageVariant) {
        if (StringUtils.isBlank((CharSequence)imageId) || context == null || imageResolution == null || imageVariant == null) {
            LOG.warn("Null parameters not allowed - ImageServerClientImpl#imageStream: imageId={}, context={}, imageResolution={}, imageVariant={}", LogHelper.flatten(imageId, context, imageResolution, imageVariant));
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"iid", (Object)imageId);
        queryParams.set((Object)"context", (Object)context);
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageResolution);
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageVariant);
        this.hashBuilder().ifPresent(arg_0 -> RemoteImageServerClient.lambda$imageStream$0((MultiValueMap)queryParams, context, imageResolution, imageVariant, arg_0));
        return new ByteArrayInputStream(this.httpGet("view", (MultiValueMap<String, String>)queryParams, byte[].class));
    }

    @Override
    public InputStream imageStream(String imageId, ImageModificationDto imageModificationDto, ImageVariantDto imageVariant) {
        if (StringUtils.isBlank((CharSequence)imageId) || imageModificationDto == null || imageVariant == null) {
            LOG.warn("Null parameters not allowed - ImageServerClientImpl#imageStream: imageId={}, imageModificationDto={}, imageResolution={}, imageVariant={}", LogHelper.flatten(imageId, imageModificationDto, imageVariant));
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"iid", (Object)imageId);
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageModificationDto);
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageVariant);
        return new ByteArrayInputStream(this.httpGet("api/image/render", (MultiValueMap<String, String>)queryParams, byte[].class));
    }

    @Override
    public InputStream imageStream(byte[] imageData, ImageModificationDto imageModificationDto, ImageVariantDto imageVariant) {
        if (imageData == null || imageModificationDto == null || imageVariant == null) {
            LOG.warn("Null parameters not allowed - ImageServerClientImpl#imageStream: imageData={}, imageModificationDto={}, imageResolution={}, imageVariant={}", LogHelper.flatten(imageData == null, imageModificationDto, imageVariant));
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageModificationDto);
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageVariant);
        MultiValueMap<String, Object> bodyParts = this.getImageDataAsBody(imageData);
        return new ByteArrayInputStream(this.httpPost("api/image/render", (MultiValueMap<String, String>)queryParams, bodyParts, byte[].class));
    }

    @Override
    public ImageInfoDto loadImage(String imageId, byte[] imageBytes) {
        return this.loadImage(imageId, imageBytes, false);
    }

    @Override
    public ImageInfoDto loadImage(String imageId, byte[] imageBytes, boolean replaceExisting) {
        return this.loadImage(imageId, imageBytes, null, replaceExisting);
    }

    @Override
    public ImageInfoDto loadImage(String imageId, byte[] imageBytes, Date imageDate) {
        return this.loadImage(imageId, imageBytes, imageDate, false);
    }

    @Override
    public ImageInfoDto loadImage(String imageId, byte[] imageBytes, Date imageDate, boolean replaceExisting) {
        if (StringUtils.isBlank((CharSequence)imageId)) {
            throw new ImageServerException("You must specify an imageId when loading an image.");
        }
        if (imageBytes == null || imageBytes.length == 0) {
            throw new ImageServerException("Unable to load an image with empty byte data.");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"iid", (Object)imageId);
        queryParams.set((Object)"replaceExisting", (Object)Boolean.toString(replaceExisting));
        if (imageDate != null) {
            queryParams.set((Object)"imageTimestamp", (Object)Long.toString(imageDate.getTime()));
        }
        MultiValueMap<String, Object> bodyParts = this.getImageDataAsBody(imageBytes);
        try {
            return (ImageInfoDto)this.httpPost("api/image/load", (MultiValueMap<String, String>)queryParams, bodyParts, ResponseTypes.IMAGE_INFO);
        }
        catch (RuntimeException e) {
            LOG.error("Loading image caused exception - ImageServerClientImpl#loadImage: imageId={}, imageBytes={}, imageDate={}", LogHelper.flatten(imageId, imageBytes.length, imageDate));
            throw e;
        }
    }

    private MultiValueMap<String, Object> getImageDataAsBody(byte[] imageBytes) {
        LinkedMultiValueMap bodyParts = new LinkedMultiValueMap();
        bodyParts.set((Object)"imageData", (Object)new ByteArrayResource(imageBytes){

            public String getFilename() {
                return "imageData";
            }
        });
        return bodyParts;
    }

    @Override
    public boolean deleteImage(String imageId) {
        if (StringUtils.isBlank((CharSequence)imageId)) {
            throw new ImageServerException("You must specify an imageId when deleting an image.");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"iid", (Object)imageId);
        Object map = this.httpPost("api/image/delete", (MultiValueMap<String, String>)queryParams, (MultiValueMap<String, ?>)new LinkedMultiValueMap(), (ParameterizedTypeReference)ResponseTypes.OBJECT);
        if (map instanceof Map) {
            return Boolean.valueOf("" + ((Map)map).get("deleted"));
        }
        return false;
    }

    @Override
    public boolean imageExists(String imageId) {
        return this.imageInfo(imageId).isExisting();
    }

    @Override
    public ImageInfoDto imageInfo(String imageId) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"iid", (Object)imageId);
        return (ImageInfoDto)this.httpGet("api/image/details", (MultiValueMap<String, String>)queryParams, ResponseTypes.IMAGE_INFO);
    }

    @Override
    public ImageInfoDto imageInfo(byte[] imageBytes) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        MultiValueMap<String, Object> bodyParts = this.getImageDataAsBody(imageBytes);
        return (ImageInfoDto)this.httpPost("api/image/details", (MultiValueMap<String, String>)queryParams, bodyParts, ResponseTypes.IMAGE_INFO);
    }

    @Override
    public List<ImageResolutionDto> pregenerateResolutions(String imageId) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"iid", (Object)imageId);
        return (List)this.httpGet("api/image/pregenerate", (MultiValueMap<String, String>)queryParams, ResponseTypes.RESOLUTIONS);
    }

    @Override
    public void registerImageModification(String imageId, String context, ImageModificationDto imageModification) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"iid", (Object)imageId);
        queryParams.set((Object)"context", (Object)context);
        this.addQueryParams((MultiValueMap<String, String>)queryParams, imageModification);
        this.httpGet("api/modification/register", (MultiValueMap<String, String>)queryParams, ResponseTypes.OBJECT);
    }

    @Override
    public void registerImageModifications(String imageId, String context, List<ImageModificationDto> imageModifications) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"iid", (Object)imageId);
        queryParams.set((Object)"context", (Object)context);
        LinkedMultiValueMap bodyParts = new LinkedMultiValueMap();
        this.addQueryParams((MultiValueMap<String, String>)bodyParts, imageModifications);
        this.httpPost("api/modification/registerlist", (MultiValueMap<String, String>)queryParams, (MultiValueMap<String, ?>)bodyParts, (ParameterizedTypeReference)ResponseTypes.OBJECT);
    }

    @Override
    public List<ImageResolutionDto> listAllowedResolutions(String context) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"context", (Object)context);
        return (List)this.httpGet("api/resolution/list", (MultiValueMap<String, String>)queryParams, ResponseTypes.RESOLUTIONS);
    }

    @Override
    public List<ImageResolutionDto> listConfigurableResolutions(String context) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"context", (Object)context);
        queryParams.set((Object)"configurableOnly", (Object)"true");
        return (List)this.httpGet("api/resolution/list", (MultiValueMap<String, String>)queryParams, ResponseTypes.RESOLUTIONS);
    }

    @Override
    public List<ImageModificationDto> listModifications(String imageId, String context) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        queryParams.set((Object)"iid", (Object)imageId);
        queryParams.set((Object)"context", (Object)context);
        return (List)this.httpGet("api/modification/list", (MultiValueMap<String, String>)queryParams, ResponseTypes.MODIFICATIONS);
    }

    @Override
    public ImageConvertResultDto convertImage(ImageConvertDto convertDto) {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        queryParams.set((Object)"token", (Object)this.imageServerAccessToken);
        return (ImageConvertResultDto)this.httpPost("api/image/convert", (MultiValueMap<String, String>)queryParams, new HttpEntity((Object)convertDto), ResponseTypes.IMAGE_CONVERT);
    }

    protected <T> T httpGet(String path, MultiValueMap<String, String> queryParams, Class<T> responseType) {
        URI url = this.buildUri(path, queryParams);
        HttpEntity request = new HttpEntity((MultiValueMap)new LinkedMultiValueMap());
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, responseType);
        return (T)response.getBody();
    }

    protected <T> T httpGet(String path, MultiValueMap<String, String> queryParams, ParameterizedTypeReference<JsonResponse<T>> responseType) {
        JsonResponse body;
        URI url = this.buildUri(path, queryParams);
        HttpEntity request = new HttpEntity((MultiValueMap)new LinkedMultiValueMap());
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, responseType);
            body = (JsonResponse)response.getBody();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new ImageServerException(e.getMessage());
        }
        if (!body.isSuccess()) {
            throw new ImageServerException(body.getErrorMessage());
        }
        return body.getResult();
    }

    protected <T> T httpPost(String path, MultiValueMap<String, String> queryParams, MultiValueMap<String, ?> bodyParams, Class<T> responseType) {
        URI url = this.buildUri(path, queryParams);
        HttpEntity request = new HttpEntity(bodyParams);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, responseType);
        return (T)response.getBody();
    }

    protected <T> T httpPost(String path, MultiValueMap<String, String> queryParams, HttpEntity payload, ParameterizedTypeReference<JsonResponse<T>> responseType) {
        URI url = this.buildUri(path, queryParams);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, payload, responseType);
        JsonResponse body = (JsonResponse)response.getBody();
        return body.getResult();
    }

    protected <T> T httpPost(String path, MultiValueMap<String, String> queryParams, MultiValueMap<String, ?> bodyParams, ParameterizedTypeReference<JsonResponse<T>> responseType) {
        HttpEntity request;
        URI url = this.buildUri(path, queryParams);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request = new HttpEntity(bodyParams), responseType);
        JsonResponse body = (JsonResponse)response.getBody();
        if (!body.isSuccess()) {
            throw new ImageServerException(body.getErrorMessage());
        }
        return body.getResult();
    }

    private static /* synthetic */ void lambda$imageStream$0(MultiValueMap queryParams, String context, ImageResolutionDto imageResolution, ImageVariantDto imageVariant, ImageRequestHashBuilder hashBuilder) {
        queryParams.set((Object)"hash", (Object)hashBuilder.calculateHash(context, null, imageResolution, imageVariant, new String[0]));
    }

    private static final class ResponseTypes {
        private static final ParameterizedTypeReference<JsonResponse<List<ImageResolutionDto>>> RESOLUTIONS = new ParameterizedTypeReference<JsonResponse<List<ImageResolutionDto>>>(){};
        private static final ParameterizedTypeReference<JsonResponse<List<ImageModificationDto>>> MODIFICATIONS = new ParameterizedTypeReference<JsonResponse<List<ImageModificationDto>>>(){};
        private static final ParameterizedTypeReference<JsonResponse<Object>> OBJECT = new ParameterizedTypeReference<JsonResponse<Object>>(){};
        private static final ParameterizedTypeReference<JsonResponse<ImageInfoDto>> IMAGE_INFO = new ParameterizedTypeReference<JsonResponse<ImageInfoDto>>(){};
        private static final ParameterizedTypeReference<JsonResponse<ImageConvertResultDto>> IMAGE_CONVERT = new ParameterizedTypeReference<JsonResponse<ImageConvertResultDto>>(){};

        private ResponseTypes() {
        }
    }
}

