/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;

public class ColorDto {
    public static final ColorDto TRANSPARENT = ColorDto.from("transparent");
    public static final ColorDto WHITE = ColorDto.from("#ffffff");
    public static final ColorDto BLACK = ColorDto.from("#000000");
    private final String value;

    public String toString() {
        return this.value.startsWith("#") ? "hex:" + this.value.substring(1) : this.value;
    }

    @JsonCreator
    public static ColorDto from(@JsonProperty(value="value") @NonNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        String lowered = value.toLowerCase();
        if (lowered.startsWith("hex:")) {
            lowered = "#" + lowered.substring(4);
        }
        return new ColorDto(lowered);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColorDto)) {
            return false;
        }
        ColorDto other = (ColorDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColorDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    private ColorDto(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

