/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.dto;

import com.foreach.imageserver.dto.DimensionsDto;
import java.util.Objects;

public class CropDto {
    private int x;
    private int y;
    private int width;
    private int height;
    private DimensionsDto source = new DimensionsDto();
    private DimensionsDto box = new DimensionsDto();

    public CropDto() {
    }

    public CropDto(CropDto original) {
        this.x = original.x;
        this.y = original.y;
        this.width = original.width;
        this.height = original.height;
        this.source = new DimensionsDto(original.getSource());
        this.box = new DimensionsDto(original.getBox());
    }

    public CropDto(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean hasBox() {
        return this.box != null && !this.box.equals(new DimensionsDto());
    }

    public boolean hasSource() {
        return this.source != null && !this.source.equals(new DimensionsDto());
    }

    public DimensionsDto getDimensions() {
        return new DimensionsDto(this.width, this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CropDto)) {
            return false;
        }
        CropDto cropDto = (CropDto)o;
        if (this.height != cropDto.height) {
            return false;
        }
        if (this.width != cropDto.width) {
            return false;
        }
        if (this.x != cropDto.x) {
            return false;
        }
        if (this.y != cropDto.y) {
            return false;
        }
        if (this.box != null ? !this.box.equals(cropDto.box) : cropDto.box != null) {
            return false;
        }
        return !(this.source != null ? !this.source.equals(cropDto.source) : cropDto.source != null);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height, this.source, this.box);
    }

    public String toString() {
        return "CropDto{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", source=" + this.source + ", box=" + this.box + '}';
    }

    public static CropDtoBuilder builder() {
        return new CropDtoBuilder();
    }

    public CropDtoBuilder toBuilder() {
        return new CropDtoBuilder().x(this.x).y(this.y).width(this.width).height(this.height).source(this.source).box(this.box);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public DimensionsDto getSource() {
        return this.source;
    }

    public DimensionsDto getBox() {
        return this.box;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSource(DimensionsDto source) {
        this.source = source;
    }

    public void setBox(DimensionsDto box) {
        this.box = box;
    }

    private CropDto(int x, int y, int width, int height, DimensionsDto source, DimensionsDto box) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.source = source;
        this.box = box;
    }

    public static class CropDtoBuilder {
        private int x;
        private int y;
        private int width;
        private int height;
        private DimensionsDto source = new DimensionsDto();
        private DimensionsDto box = new DimensionsDto();

        CropDtoBuilder() {
        }

        public CropDtoBuilder x(int x) {
            this.x = x;
            return this;
        }

        public CropDtoBuilder y(int y) {
            this.y = y;
            return this;
        }

        public CropDtoBuilder width(int width) {
            this.width = width;
            return this;
        }

        public CropDtoBuilder height(int height) {
            this.height = height;
            return this;
        }

        public CropDtoBuilder source(DimensionsDto source) {
            this.source = source;
            return this;
        }

        public CropDtoBuilder box(DimensionsDto box) {
            this.box = box;
            return this;
        }

        public CropDto build() {
            return new CropDto(this.x, this.y, this.width, this.height, this.source, this.box);
        }

        public String toString() {
            return "CropDto.CropDtoBuilder(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", source=" + this.source + ", box=" + this.box + ")";
        }
    }
}

