/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.dto;

import java.util.Objects;

public class DimensionsDto {
    private int width;
    private int height;

    public DimensionsDto() {
    }

    public DimensionsDto(DimensionsDto original) {
        this.width = original.width;
        this.height = original.height;
    }

    public DimensionsDto(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean isEmpty() {
        return this.width == 0 && this.height == 0;
    }

    public boolean hasUnspecifiedDimension() {
        return this.width == 0 || this.height == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DimensionsDto)) {
            return false;
        }
        DimensionsDto that = (DimensionsDto)o;
        if (this.height != that.height) {
            return false;
        }
        return this.width == that.width;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height);
    }

    public String toString() {
        return "{width=" + this.width + ", height=" + this.height + '}';
    }

    public static DimensionsDtoBuilder builder() {
        return new DimensionsDtoBuilder();
    }

    public DimensionsDtoBuilder toBuilder() {
        return new DimensionsDtoBuilder().width(this.width).height(this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public static class DimensionsDtoBuilder {
        private int width;
        private int height;

        DimensionsDtoBuilder() {
        }

        public DimensionsDtoBuilder width(int width) {
            this.width = width;
            return this;
        }

        public DimensionsDtoBuilder height(int height) {
            this.height = height;
            return this;
        }

        public DimensionsDto build() {
            return new DimensionsDto(this.width, this.height);
        }

        public String toString() {
            return "DimensionsDto.DimensionsDtoBuilder(width=" + this.width + ", height=" + this.height + ")";
        }
    }
}

