/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.dto;

import com.foreach.imageserver.dto.ImageTransformDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImageConvertDto {
    private byte[] image;
    private String imageId;
    private String pages;
    private Map<String, List<ImageTransformDto>> transformations;

    public static ImageConvertDtoBuilder builder() {
        return new ImageConvertDtoBuilder();
    }

    public byte[] getImage() {
        return this.image;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getPages() {
        return this.pages;
    }

    public Map<String, List<ImageTransformDto>> getTransformations() {
        return this.transformations;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public void setPages(String pages) {
        this.pages = pages;
    }

    public void setTransformations(Map<String, List<ImageTransformDto>> transformations) {
        this.transformations = transformations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageConvertDto)) {
            return false;
        }
        ImageConvertDto other = (ImageConvertDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getImage(), other.getImage())) {
            return false;
        }
        String this$imageId = this.getImageId();
        String other$imageId = other.getImageId();
        if (this$imageId == null ? other$imageId != null : !this$imageId.equals(other$imageId)) {
            return false;
        }
        String this$pages = this.getPages();
        String other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !this$pages.equals(other$pages)) {
            return false;
        }
        Map<String, List<ImageTransformDto>> this$transformations = this.getTransformations();
        Map<String, List<ImageTransformDto>> other$transformations = other.getTransformations();
        return !(this$transformations == null ? other$transformations != null : !((Object)this$transformations).equals(other$transformations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageConvertDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getImage());
        String $imageId = this.getImageId();
        result = result * 59 + ($imageId == null ? 43 : $imageId.hashCode());
        String $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : $pages.hashCode());
        Map<String, List<ImageTransformDto>> $transformations = this.getTransformations();
        result = result * 59 + ($transformations == null ? 43 : ((Object)$transformations).hashCode());
        return result;
    }

    public String toString() {
        return "ImageConvertDto(image=" + Arrays.toString(this.getImage()) + ", imageId=" + this.getImageId() + ", pages=" + this.getPages() + ", transformations=" + this.getTransformations() + ")";
    }

    public ImageConvertDto() {
    }

    public ImageConvertDto(byte[] image, String imageId, String pages, Map<String, List<ImageTransformDto>> transformations) {
        this.image = image;
        this.imageId = imageId;
        this.pages = pages;
        this.transformations = transformations;
    }

    public static class ImageConvertDtoBuilder {
        private byte[] image;
        private String imageId;
        private String pages;
        private ArrayList<String> transformations$key;
        private ArrayList<List<ImageTransformDto>> transformations$value;

        ImageConvertDtoBuilder() {
        }

        public ImageConvertDtoBuilder image(byte[] image) {
            this.image = image;
            return this;
        }

        public ImageConvertDtoBuilder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public ImageConvertDtoBuilder pages(String pages) {
            this.pages = pages;
            return this;
        }

        public ImageConvertDtoBuilder transformation(String transformationKey, List<ImageTransformDto> transformationValue) {
            if (this.transformations$key == null) {
                this.transformations$key = new ArrayList();
                this.transformations$value = new ArrayList();
            }
            this.transformations$key.add(transformationKey);
            this.transformations$value.add(transformationValue);
            return this;
        }

        public ImageConvertDtoBuilder transformations(Map<? extends String, ? extends List<ImageTransformDto>> transformations) {
            if (transformations == null) {
                throw new IllegalArgumentException("transformations cannot be null");
            }
            if (this.transformations$key == null) {
                this.transformations$key = new ArrayList();
                this.transformations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends List<ImageTransformDto>> $lombokEntry : transformations.entrySet()) {
                this.transformations$key.add($lombokEntry.getKey());
                this.transformations$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ImageConvertDtoBuilder clearTransformations() {
            if (this.transformations$key != null) {
                this.transformations$key.clear();
                this.transformations$value.clear();
            }
            return this;
        }

        public ImageConvertDto build() {
            Map<String, List<ImageTransformDto>> transformations;
            switch (this.transformations$key == null ? 0 : this.transformations$key.size()) {
                case 0: {
                    transformations = Collections.emptyMap();
                    break;
                }
                case 1: {
                    transformations = Collections.singletonMap(this.transformations$key.get(0), this.transformations$value.get(0));
                    break;
                }
                default: {
                    transformations = new LinkedHashMap(this.transformations$key.size() < 0x40000000 ? 1 + this.transformations$key.size() + (this.transformations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.transformations$key.size(); ++$i) {
                        transformations.put(this.transformations$key.get($i), this.transformations$value.get($i));
                    }
                    transformations = Collections.unmodifiableMap(transformations);
                }
            }
            return new ImageConvertDto(this.image, this.imageId, this.pages, transformations);
        }

        public String toString() {
            return "ImageConvertDto.ImageConvertDtoBuilder(image=" + Arrays.toString(this.image) + ", imageId=" + this.imageId + ", pages=" + this.pages + ", transformations$key=" + this.transformations$key + ", transformations$value=" + this.transformations$value + ")";
        }
    }
}

