/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.dto;

import com.foreach.imageserver.dto.CropDto;
import com.foreach.imageserver.dto.DimensionsDto;
import com.foreach.imageserver.dto.ImageResolutionDto;
import com.foreach.imageserver.dto.ImageTransformDto;
import java.util.Objects;

public class ImageModificationDto {
    private Long baseResolutionId;
    private ImageResolutionDto resolution;
    private CropDto crop;
    private DimensionsDto density;
    private DimensionsDto boundaries;

    public ImageModificationDto() {
        this.resolution = new ImageResolutionDto();
        this.crop = new CropDto();
        this.density = new DimensionsDto();
        this.boundaries = new DimensionsDto();
    }

    public ImageModificationDto(ImageModificationDto original) {
        this.resolution = new ImageResolutionDto(original.getResolution());
        this.crop = new CropDto(original.getCrop());
        this.density = new DimensionsDto(original.getDensity());
        this.boundaries = new DimensionsDto(original.getBoundaries());
    }

    public ImageModificationDto(int width, int height) {
        this();
        this.resolution.setWidth(width);
        this.resolution.setHeight(height);
    }

    public ImageModificationDto(ImageResolutionDto resolution, CropDto crop, DimensionsDto density) {
        this(resolution, crop, density, new DimensionsDto());
    }

    public ImageModificationDto(ImageResolutionDto resolution, CropDto crop, DimensionsDto density, DimensionsDto boundaries) {
        this.resolution = resolution;
        this.crop = crop;
        this.density = density;
        this.boundaries = boundaries;
    }

    public boolean hasCrop() {
        return this.crop != null && !this.crop.equals(new CropDto());
    }

    public boolean hasBoundaries() {
        return this.boundaries != null && !this.boundaries.equals(new DimensionsDto());
    }

    public boolean isRegistered() {
        return this.baseResolutionId != null && this.resolution != null && this.baseResolutionId.equals(this.resolution.getId());
    }

    public ImageTransformDto asTransformDto() {
        return ImageTransformDto.builder().width(this.resolution.getWidth()).height(this.resolution.getHeight()).crop(new CropDto().equals(this.crop) ? null : this.crop).maxWidth(this.boundaries.isEmpty() ? null : Integer.valueOf(this.boundaries.getWidth())).maxHeight(this.boundaries.isEmpty() ? null : Integer.valueOf(this.boundaries.getHeight())).dpi(this.density.isEmpty() ? null : Integer.valueOf(this.density.getWidth())).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageModificationDto)) {
            return false;
        }
        ImageModificationDto that = (ImageModificationDto)o;
        return Objects.equals(this.boundaries, that.boundaries) && Objects.equals(this.crop, that.crop) && Objects.equals(this.density, that.density) && Objects.equals(this.resolution, that.resolution);
    }

    public int hashCode() {
        return Objects.hash(this.resolution, this.crop, this.density, this.boundaries);
    }

    public Long getBaseResolutionId() {
        return this.baseResolutionId;
    }

    public ImageResolutionDto getResolution() {
        return this.resolution;
    }

    public CropDto getCrop() {
        return this.crop;
    }

    public DimensionsDto getDensity() {
        return this.density;
    }

    public DimensionsDto getBoundaries() {
        return this.boundaries;
    }

    public void setBaseResolutionId(Long baseResolutionId) {
        this.baseResolutionId = baseResolutionId;
    }

    public void setResolution(ImageResolutionDto resolution) {
        this.resolution = resolution;
    }

    public void setCrop(CropDto crop) {
        this.crop = crop;
    }

    public void setDensity(DimensionsDto density) {
        this.density = density;
    }

    public void setBoundaries(DimensionsDto boundaries) {
        this.boundaries = boundaries;
    }
}

