/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.dto;

import com.foreach.imageserver.dto.DimensionsDto;
import com.foreach.imageserver.dto.ImageTypeDto;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class ImageResolutionDto {
    private Long id;
    private boolean configurable;
    private boolean pregenerateVariants;
    private String name;
    private int width;
    private int height;
    private Set<ImageTypeDto> allowedOutputTypes = EnumSet.noneOf(ImageTypeDto.class);
    private Set<String> tags = new HashSet<String>();

    public ImageResolutionDto() {
    }

    public ImageResolutionDto(ImageResolutionDto original) {
        this.width = original.width;
        this.height = original.height;
    }

    public ImageResolutionDto(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public DimensionsDto getDimensions() {
        return new DimensionsDto(this.width, this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageResolutionDto)) {
            return false;
        }
        ImageResolutionDto that = (ImageResolutionDto)o;
        if (this.height != that.height) {
            return false;
        }
        return this.width == that.width;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public boolean isPregenerateVariants() {
        return this.pregenerateVariants;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Set<ImageTypeDto> getAllowedOutputTypes() {
        return this.allowedOutputTypes;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setConfigurable(boolean configurable) {
        this.configurable = configurable;
    }

    public void setPregenerateVariants(boolean pregenerateVariants) {
        this.pregenerateVariants = pregenerateVariants;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setAllowedOutputTypes(Set<ImageTypeDto> allowedOutputTypes) {
        this.allowedOutputTypes = allowedOutputTypes;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }
}

