/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.dto;

import com.foreach.imageserver.dto.ColorDto;
import com.foreach.imageserver.dto.ColorSpaceDto;
import com.foreach.imageserver.dto.CropDto;
import com.foreach.imageserver.dto.ImageTypeDto;
import com.foreach.imageserver.math.AspectRatio;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ImageTransformDto {
    private Integer scene;
    private Integer width;
    private Integer height;
    private Integer maxWidth;
    private Integer maxHeight;
    private AspectRatio aspectRatio;
    private Integer dpi;
    private CropDto crop;
    private Integer quality;
    private ColorDto backgroundColor;
    private ColorDto alphaColor;
    private ColorSpaceDto colorSpace;
    private ImageTypeDto outputType;

    public static ImageTransformDto from(@NonNull String transformString) {
        if (transformString == null) {
            throw new IllegalArgumentException("transformString is marked non-null but is null");
        }
        ImageTransformDto dto = new ImageTransformDto();
        CropDto crop = new CropDto();
        Stream.of(transformString.split(",")).map(StringParam::parse).forEach(param -> {
            if ("w".equals(((StringParam)param).key)) {
                dto.width = param.intValue();
            } else if ("h".equals(((StringParam)param).key)) {
                dto.height = param.intValue();
            } else if ("scene".equals(((StringParam)param).key)) {
                dto.scene = param.intValue();
            } else if ("maxw".equals(((StringParam)param).key)) {
                dto.maxWidth = param.intValue();
            } else if ("maxh".equals(((StringParam)param).key)) {
                dto.maxHeight = param.intValue();
            } else if ("dpi".equals(((StringParam)param).key)) {
                dto.dpi = param.intValue();
            } else if ("cx".equals(((StringParam)param).key)) {
                crop.setX(param.intValue());
            } else if ("cy".equals(((StringParam)param).key)) {
                crop.setY(param.intValue());
            } else if ("cw".equals(((StringParam)param).key)) {
                crop.setWidth(param.intValue());
            } else if ("ch".equals(((StringParam)param).key)) {
                crop.setHeight(param.intValue());
            } else if ("csw".equals(((StringParam)param).key)) {
                crop.getSource().setWidth(param.intValue());
            } else if ("csh".equals(((StringParam)param).key)) {
                crop.getSource().setHeight(param.intValue());
            } else if ("cbw".equals(((StringParam)param).key)) {
                crop.getBox().setWidth(param.intValue());
            } else if ("cbh".equals(((StringParam)param).key)) {
                crop.getBox().setHeight(param.intValue());
            } else if ("bg".equals(((StringParam)param).key)) {
                dto.backgroundColor = ColorDto.from(param.stringValue());
            } else if ("alpha".equals(((StringParam)param).key)) {
                dto.alphaColor = ColorDto.from(param.stringValue());
            } else if ("color".equals(((StringParam)param).key)) {
                dto.colorSpace = ColorSpaceDto.valueOf(StringUtils.upperCase((String)param.stringValue()));
            } else if ("q".equals(((StringParam)param).key)) {
                dto.quality = param.intValue();
            } else if ("o".equals(((StringParam)param).key)) {
                dto.outputType = ImageTypeDto.forExtension(param.stringValue());
            } else if ("ar".equals(((StringParam)param).key)) {
                dto.aspectRatio = new AspectRatio(StringUtils.replace((String)param.stringValue(), (String)":", (String)"/"));
            }
        });
        if (!crop.equals(new CropDto())) {
            dto.crop = crop;
        }
        return dto;
    }

    public String toString() {
        ArrayList<StringParam> parameters = new ArrayList<StringParam>();
        parameters.add(new StringParam("scene", this.scene));
        parameters.add(new StringParam("w", this.width));
        parameters.add(new StringParam("h", this.height));
        parameters.add(new StringParam("maxw", this.maxWidth));
        parameters.add(new StringParam("maxh", this.maxHeight));
        if (this.aspectRatio != null) {
            parameters.add(new StringParam("ar", this.aspectRatio.toString().replace("/", ":")));
        }
        if (this.crop != null) {
            parameters.add(new StringParam("cx", this.crop.getX()));
            parameters.add(new StringParam("cy", this.crop.getY()));
            parameters.add(new StringParam("cw", this.crop.getWidth()));
            parameters.add(new StringParam("ch", this.crop.getHeight()));
            if (this.crop.hasSource()) {
                parameters.add(new StringParam("csw", this.crop.getSource().getWidth()));
                parameters.add(new StringParam("csh", this.crop.getSource().getHeight()));
            }
            if (this.crop.hasBox()) {
                parameters.add(new StringParam("cbw", this.crop.getBox().getWidth()));
                parameters.add(new StringParam("cbh", this.crop.getBox().getHeight()));
            }
        }
        if (this.colorSpace != null) {
            parameters.add(new StringParam("color", StringUtils.lowerCase((String)this.colorSpace.name())));
        }
        parameters.add(new StringParam("bg", this.backgroundColor));
        parameters.add(new StringParam("alpha", this.alphaColor));
        parameters.add(new StringParam("dpi", this.dpi));
        parameters.add(new StringParam("q", this.quality));
        if (this.outputType != null) {
            parameters.add(new StringParam("o", this.outputType.getExtension()));
        }
        return parameters.stream().map(StringParam::toString).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    public boolean isEmpty() {
        return this.equals(new ImageTransformDto());
    }

    public static ImageTransformDtoBuilder builder() {
        return new ImageTransformDtoBuilder();
    }

    public ImageTransformDtoBuilder toBuilder() {
        return new ImageTransformDtoBuilder().scene(this.scene).width(this.width).height(this.height).maxWidth(this.maxWidth).maxHeight(this.maxHeight).aspectRatio(this.aspectRatio).dpi(this.dpi).crop(this.crop).quality(this.quality).backgroundColor(this.backgroundColor).alphaColor(this.alphaColor).colorSpace(this.colorSpace).outputType(this.outputType);
    }

    public Integer getScene() {
        return this.scene;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public Integer getMaxHeight() {
        return this.maxHeight;
    }

    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public Integer getDpi() {
        return this.dpi;
    }

    public CropDto getCrop() {
        return this.crop;
    }

    public Integer getQuality() {
        return this.quality;
    }

    public ColorDto getBackgroundColor() {
        return this.backgroundColor;
    }

    public ColorDto getAlphaColor() {
        return this.alphaColor;
    }

    public ColorSpaceDto getColorSpace() {
        return this.colorSpace;
    }

    public ImageTypeDto getOutputType() {
        return this.outputType;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public void setCrop(CropDto crop) {
        this.crop = crop;
    }

    public void setQuality(Integer quality) {
        this.quality = quality;
    }

    public void setBackgroundColor(ColorDto backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setAlphaColor(ColorDto alphaColor) {
        this.alphaColor = alphaColor;
    }

    public void setColorSpace(ColorSpaceDto colorSpace) {
        this.colorSpace = colorSpace;
    }

    public void setOutputType(ImageTypeDto outputType) {
        this.outputType = outputType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageTransformDto)) {
            return false;
        }
        ImageTransformDto other = (ImageTransformDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$scene = this.getScene();
        Integer other$scene = other.getScene();
        if (this$scene == null ? other$scene != null : !((Object)this$scene).equals(other$scene)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$maxWidth = this.getMaxWidth();
        Integer other$maxWidth = other.getMaxWidth();
        if (this$maxWidth == null ? other$maxWidth != null : !((Object)this$maxWidth).equals(other$maxWidth)) {
            return false;
        }
        Integer this$maxHeight = this.getMaxHeight();
        Integer other$maxHeight = other.getMaxHeight();
        if (this$maxHeight == null ? other$maxHeight != null : !((Object)this$maxHeight).equals(other$maxHeight)) {
            return false;
        }
        Integer this$dpi = this.getDpi();
        Integer other$dpi = other.getDpi();
        if (this$dpi == null ? other$dpi != null : !((Object)this$dpi).equals(other$dpi)) {
            return false;
        }
        Integer this$quality = this.getQuality();
        Integer other$quality = other.getQuality();
        if (this$quality == null ? other$quality != null : !((Object)this$quality).equals(other$quality)) {
            return false;
        }
        AspectRatio this$aspectRatio = this.getAspectRatio();
        AspectRatio other$aspectRatio = other.getAspectRatio();
        if (this$aspectRatio == null ? other$aspectRatio != null : !((Object)this$aspectRatio).equals(other$aspectRatio)) {
            return false;
        }
        CropDto this$crop = this.getCrop();
        CropDto other$crop = other.getCrop();
        if (this$crop == null ? other$crop != null : !((Object)this$crop).equals(other$crop)) {
            return false;
        }
        ColorDto this$backgroundColor = this.getBackgroundColor();
        ColorDto other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        ColorDto this$alphaColor = this.getAlphaColor();
        ColorDto other$alphaColor = other.getAlphaColor();
        if (this$alphaColor == null ? other$alphaColor != null : !((Object)this$alphaColor).equals(other$alphaColor)) {
            return false;
        }
        ColorSpaceDto this$colorSpace = this.getColorSpace();
        ColorSpaceDto other$colorSpace = other.getColorSpace();
        if (this$colorSpace == null ? other$colorSpace != null : !((Object)((Object)this$colorSpace)).equals((Object)other$colorSpace)) {
            return false;
        }
        ImageTypeDto this$outputType = this.getOutputType();
        ImageTypeDto other$outputType = other.getOutputType();
        return !(this$outputType == null ? other$outputType != null : !((Object)((Object)this$outputType)).equals((Object)other$outputType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageTransformDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $scene = this.getScene();
        result = result * 59 + ($scene == null ? 43 : ((Object)$scene).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $maxWidth = this.getMaxWidth();
        result = result * 59 + ($maxWidth == null ? 43 : ((Object)$maxWidth).hashCode());
        Integer $maxHeight = this.getMaxHeight();
        result = result * 59 + ($maxHeight == null ? 43 : ((Object)$maxHeight).hashCode());
        Integer $dpi = this.getDpi();
        result = result * 59 + ($dpi == null ? 43 : ((Object)$dpi).hashCode());
        Integer $quality = this.getQuality();
        result = result * 59 + ($quality == null ? 43 : ((Object)$quality).hashCode());
        AspectRatio $aspectRatio = this.getAspectRatio();
        result = result * 59 + ($aspectRatio == null ? 43 : ((Object)$aspectRatio).hashCode());
        CropDto $crop = this.getCrop();
        result = result * 59 + ($crop == null ? 43 : ((Object)$crop).hashCode());
        ColorDto $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        ColorDto $alphaColor = this.getAlphaColor();
        result = result * 59 + ($alphaColor == null ? 43 : ((Object)$alphaColor).hashCode());
        ColorSpaceDto $colorSpace = this.getColorSpace();
        result = result * 59 + ($colorSpace == null ? 43 : ((Object)((Object)$colorSpace)).hashCode());
        ImageTypeDto $outputType = this.getOutputType();
        result = result * 59 + ($outputType == null ? 43 : ((Object)((Object)$outputType)).hashCode());
        return result;
    }

    public ImageTransformDto() {
    }

    private ImageTransformDto(Integer scene, Integer width, Integer height, Integer maxWidth, Integer maxHeight, AspectRatio aspectRatio, Integer dpi, CropDto crop, Integer quality, ColorDto backgroundColor, ColorDto alphaColor, ColorSpaceDto colorSpace, ImageTypeDto outputType) {
        this.scene = scene;
        this.width = width;
        this.height = height;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.aspectRatio = aspectRatio;
        this.dpi = dpi;
        this.crop = crop;
        this.quality = quality;
        this.backgroundColor = backgroundColor;
        this.alphaColor = alphaColor;
        this.colorSpace = colorSpace;
        this.outputType = outputType;
    }

    public static class ImageTransformDtoBuilder {
        private Integer scene;
        private Integer width;
        private Integer height;
        private Integer maxWidth;
        private Integer maxHeight;
        private AspectRatio aspectRatio;
        private Integer dpi;
        private CropDto crop;
        private Integer quality;
        private ColorDto backgroundColor;
        private ColorDto alphaColor;
        private ColorSpaceDto colorSpace;
        private ImageTypeDto outputType;

        ImageTransformDtoBuilder() {
        }

        public ImageTransformDtoBuilder scene(Integer scene) {
            this.scene = scene;
            return this;
        }

        public ImageTransformDtoBuilder width(Integer width) {
            this.width = width;
            return this;
        }

        public ImageTransformDtoBuilder height(Integer height) {
            this.height = height;
            return this;
        }

        public ImageTransformDtoBuilder maxWidth(Integer maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public ImageTransformDtoBuilder maxHeight(Integer maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public ImageTransformDtoBuilder aspectRatio(AspectRatio aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public ImageTransformDtoBuilder dpi(Integer dpi) {
            this.dpi = dpi;
            return this;
        }

        public ImageTransformDtoBuilder crop(CropDto crop) {
            this.crop = crop;
            return this;
        }

        public ImageTransformDtoBuilder quality(Integer quality) {
            this.quality = quality;
            return this;
        }

        public ImageTransformDtoBuilder backgroundColor(ColorDto backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public ImageTransformDtoBuilder alphaColor(ColorDto alphaColor) {
            this.alphaColor = alphaColor;
            return this;
        }

        public ImageTransformDtoBuilder colorSpace(ColorSpaceDto colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        public ImageTransformDtoBuilder outputType(ImageTypeDto outputType) {
            this.outputType = outputType;
            return this;
        }

        public ImageTransformDto build() {
            return new ImageTransformDto(this.scene, this.width, this.height, this.maxWidth, this.maxHeight, this.aspectRatio, this.dpi, this.crop, this.quality, this.backgroundColor, this.alphaColor, this.colorSpace, this.outputType);
        }

        public String toString() {
            return "ImageTransformDto.ImageTransformDtoBuilder(scene=" + this.scene + ", width=" + this.width + ", height=" + this.height + ", maxWidth=" + this.maxWidth + ", maxHeight=" + this.maxHeight + ", aspectRatio=" + this.aspectRatio + ", dpi=" + this.dpi + ", crop=" + this.crop + ", quality=" + this.quality + ", backgroundColor=" + this.backgroundColor + ", alphaColor=" + this.alphaColor + ", colorSpace=" + (Object)((Object)this.colorSpace) + ", outputType=" + (Object)((Object)this.outputType) + ")";
        }
    }

    private static class StringParam {
        private final String key;
        private final Object value;

        static StringParam parse(String s) {
            String key = StringUtils.substringBefore((String)s, (String)"_");
            String value = StringUtils.substringAfter((String)s, (String)"_");
            return new StringParam(key, value);
        }

        int intValue() {
            return Integer.parseInt(Objects.toString(this.value));
        }

        String stringValue() {
            return Objects.toString(this.value);
        }

        public String toString() {
            return this.value != null ? this.key + "_" + this.value : null;
        }

        public StringParam(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

