/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.math;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;

public class AspectRatio {
    private static final Pattern RATIO_PATTERN = Pattern.compile("(\\d+)/(\\d+)");
    private final Ratio ratio;
    public static final AspectRatio ONE = new AspectRatio(1, 1);
    public static final AspectRatio UNDEFINED = new AspectRatio(0, 0);

    public AspectRatio(String ratio) {
        Matcher matcher = RATIO_PATTERN.matcher(ratio);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Ratio should be of pattern: \"p/q\"");
        }
        int p = NumberUtils.toInt((String)matcher.group(1));
        int q = NumberUtils.toInt((String)matcher.group(2));
        this.ratio = new Ratio(p, q);
    }

    public AspectRatio(int p, int q) {
        this.ratio = new Ratio(p, q);
    }

    public final int getNumerator() {
        return this.ratio.getP();
    }

    public final int getDenominator() {
        return this.ratio.getQ();
    }

    public final boolean isUndefined() {
        return this.getNumerator() == 0 || this.getDenominator() == 0;
    }

    public int calculateWidthForHeight(int height) {
        return Math.round((float)this.getNumerator() * (float)height / (float)this.getDenominator());
    }

    public int calculateHeightForWidth(int width) {
        return Math.round((float)this.getDenominator() * (float)width / (float)this.getNumerator());
    }

    public boolean isLargerOnWidth() {
        return this.getNumerator() > this.getDenominator();
    }

    public boolean isLargerOnHeight() {
        return this.getDenominator() > this.getNumerator();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AspectRatio other = (AspectRatio)o;
        return this.getDenominator() == other.getDenominator() && this.getNumerator() == other.getNumerator();
    }

    private static boolean validInteger(long l) {
        return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
    }

    private static AspectRatio boundsCheck(long p, long q) {
        if (!AspectRatio.validInteger(p) || !AspectRatio.validInteger(q)) {
            throw new ArithmeticException("The result of the operation can not be accurately represented as a fraction");
        }
        return new AspectRatio((int)p, (int)q);
    }

    public final AspectRatio multiplyWith(AspectRatio multiplicator) {
        long numerator = (long)this.getNumerator() * (long)multiplicator.getNumerator();
        long denominator = (long)this.getDenominator() * (long)multiplicator.getDenominator();
        return AspectRatio.boundsCheck(numerator, denominator);
    }

    public final AspectRatio divideBy(AspectRatio dividor) {
        long numerator = (long)this.getNumerator() * (long)dividor.getDenominator();
        long denominator = (long)this.getDenominator() * (long)dividor.getNumerator();
        return AspectRatio.boundsCheck(numerator, denominator);
    }

    public final AspectRatio addInteger(int addend) {
        long numerator = (long)this.getDenominator() * (long)addend + (long)this.getNumerator();
        long denominator = this.getDenominator();
        return AspectRatio.boundsCheck(numerator, denominator);
    }

    public final boolean isNegative() {
        return this.getNumerator() < 0;
    }

    public final String toString() {
        if (this.equals(UNDEFINED)) {
            return "undefined";
        }
        return this.getNumerator() + "/" + this.getDenominator();
    }

    public final int hashCode() {
        return this.ratio.hashCode();
    }

    private final class Ratio {
        private final int p;
        private final int q;

        public Ratio(int p, int q) {
            int gcd = this.gcd(q, p);
            int n = q == 0 ? 0 : (this.p = (q > 0 ? p : -p) / gcd);
            this.q = q == 0 ? 0 : (q > 0 ? q : -q) / gcd;
        }

        public int getP() {
            return this.p;
        }

        public int getQ() {
            return this.q;
        }

        public final int hashCode() {
            return 10007 * this.p + this.q;
        }

        private int gcd(int a, int b) {
            int nb;
            int na = a < 0 ? -a : a;
            int n = nb = b < 0 ? -b : b;
            if (na == 0) {
                return nb;
            }
            if (nb == 0) {
                return na;
            }
            while (nb != 0) {
                int temp = nb;
                nb = na % nb;
                na = temp;
            }
            return na;
        }
    }
}

