/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.imageserver.math;

import com.foreach.imageserver.dto.CropDto;
import com.foreach.imageserver.dto.DimensionsDto;
import com.foreach.imageserver.dto.ImageResolutionDto;
import com.foreach.imageserver.math.AspectRatio;
import lombok.NonNull;
import org.springframework.util.Assert;

public class ImageServerConversionUtils {
    private ImageServerConversionUtils() {
    }

    public static AspectRatio calculateAspectRatio(ImageResolutionDto resolutionDto) {
        return ImageServerConversionUtils.calculateAspectRatio(resolutionDto.getDimensions());
    }

    public static AspectRatio calculateAspectRatio(DimensionsDto dimensions) {
        return new AspectRatio(dimensions.getWidth(), dimensions.getHeight());
    }

    public static CropDto extendCrop(CropDto original, AspectRatio aspectRatio) {
        CropDto cropDto = new CropDto(original);
        DimensionsDto cropDimensions = cropDto.getDimensions();
        cropDimensions = ImageServerConversionUtils.normalize(cropDimensions, aspectRatio);
        cropDto.setX(cropDto.getX() - (cropDimensions.getWidth() - cropDto.getWidth()) / 2);
        cropDto.setY(cropDto.getY() - (cropDimensions.getHeight() - cropDto.getHeight()) / 2);
        cropDto.setWidth(cropDimensions.getWidth());
        cropDto.setHeight(cropDimensions.getHeight());
        return cropDto;
    }

    public static CropDto shrinkCrop(CropDto original, AspectRatio aspectRatio) {
        CropDto cropDto = new CropDto(original);
        DimensionsDto originalDimensions = cropDto.getDimensions();
        DimensionsDto cropDimensions = ImageServerConversionUtils.normalize(originalDimensions, aspectRatio);
        cropDimensions = ImageServerConversionUtils.scaleToFitIn(cropDimensions, originalDimensions);
        cropDto.setX(cropDto.getX() + (cropDto.getWidth() - cropDimensions.getWidth()) / 2);
        cropDto.setY(cropDto.getY() + (cropDto.getHeight() - cropDimensions.getHeight()) / 2);
        cropDto.setWidth(cropDimensions.getWidth());
        cropDto.setHeight(cropDimensions.getHeight());
        return cropDto;
    }

    public static CropDto moveToFit(CropDto original, DimensionsDto box) {
        CropDto cropDto = new CropDto(original);
        if (!ImageServerConversionUtils.fitsIn(cropDto.getDimensions(), box)) {
            throw new IllegalArgumentException("Crop dimensions are larger than the box dimensions - impossible to fit");
        }
        if (cropDto.getX() < 0) {
            cropDto.setX(0);
        }
        if (cropDto.getY() < 0) {
            cropDto.setY(0);
        }
        if (cropDto.getX() + cropDto.getWidth() > box.getWidth()) {
            cropDto.setX(box.getWidth() - cropDto.getWidth());
        }
        if (cropDto.getY() + cropDto.getHeight() > box.getHeight()) {
            cropDto.setY(box.getHeight() - cropDto.getHeight());
        }
        return cropDto;
    }

    public static DimensionsDto normalize(DimensionsDto original, DimensionsDto boundaries) {
        DimensionsDto normalized = new DimensionsDto(original.getWidth(), original.getHeight());
        AspectRatio originalAspectRatio = ImageServerConversionUtils.calculateAspectRatio(boundaries);
        if (original.getWidth() == 0 && original.getHeight() == 0) {
            normalized.setWidth(boundaries.getWidth());
            normalized.setHeight(boundaries.getHeight());
        } else if (original.getHeight() == 0) {
            normalized.setHeight(originalAspectRatio.calculateHeightForWidth(original.getWidth()));
        } else if (original.getWidth() == 0) {
            normalized.setWidth(originalAspectRatio.calculateWidthForHeight(original.getHeight()));
        }
        return normalized;
    }

    public static DimensionsDto normalize(DimensionsDto original, AspectRatio aspectRatio) {
        DimensionsDto normalized = new DimensionsDto(original.getWidth(), original.getHeight());
        if (!ImageServerConversionUtils.calculateAspectRatio(normalized).equals(aspectRatio)) {
            int newWidth = aspectRatio.calculateWidthForHeight(normalized.getHeight());
            if (newWidth < normalized.getWidth()) {
                normalized.setHeight(aspectRatio.calculateHeightForWidth(normalized.getWidth()));
            } else {
                normalized.setWidth(newWidth);
            }
        }
        return normalized;
    }

    public static CropDto normalize(CropDto original, DimensionsDto box) {
        if (original.getSource() == null || original.getSource().equals(new DimensionsDto())) {
            throw new IllegalArgumentException("Normalizing a crop requires a valid source to be set.");
        }
        CropDto translated = new CropDto(original);
        DimensionsDto newSource = ImageServerConversionUtils.scaleToFitIn(original.getSource(), box);
        ImageServerConversionUtils.translateCropToNewSource(translated, newSource);
        translated.setSource(newSource);
        translated.setBox(box);
        if (translated.getWidth() == 0 || translated.getHeight() == 0) {
            throw new RuntimeException("Could not process crop: resulted in an illegal width or height of 0");
        }
        return translated;
    }

    private static void translateCropToNewSource(CropDto crop, DimensionsDto newDimensions) {
        int leftX = crop.getX();
        int leftY = crop.getY();
        int rightX = leftX + crop.getWidth();
        int rightY = leftY + crop.getHeight();
        DimensionsDto source = crop.getSource();
        leftX = ImageServerConversionUtils.snap(leftX, source.getWidth());
        leftY = ImageServerConversionUtils.snap(leftY, source.getHeight());
        rightX = ImageServerConversionUtils.snap(rightX, source.getWidth());
        rightY = ImageServerConversionUtils.snap(rightY, source.getHeight());
        if (!newDimensions.equals(source)) {
            double modX = (double)newDimensions.getWidth() / (double)source.getWidth();
            double modY = (double)newDimensions.getHeight() / (double)source.getHeight();
            crop.setX(Double.valueOf((double)leftX * modX).intValue());
            crop.setY(Double.valueOf((double)leftY * modY).intValue());
            crop.setWidth(Double.valueOf((double)(rightX - leftX) * modX).intValue());
            crop.setHeight(Double.valueOf((double)(rightY - leftY) * modY).intValue());
        } else {
            crop.setX(leftX);
            crop.setY(leftY);
            crop.setWidth(rightX - leftX);
            crop.setHeight(rightY - leftY);
        }
    }

    private static int snap(int pos, int max) {
        if (pos < 0) {
            return 0;
        }
        if (pos > max) {
            return max;
        }
        return pos;
    }

    public static DimensionsDto scaleToFitIn(DimensionsDto original, DimensionsDto box) {
        DimensionsDto normalized = ImageServerConversionUtils.normalize(original, box);
        DimensionsDto scaled = new DimensionsDto(normalized.getWidth(), normalized.getHeight());
        AspectRatio aspectRatio = ImageServerConversionUtils.calculateAspectRatio(normalized);
        if (!ImageServerConversionUtils.fitsIn(normalized, box)) {
            if (aspectRatio.isLargerOnWidth()) {
                scaled.setWidth(box.getWidth());
                scaled.setHeight(aspectRatio.calculateHeightForWidth(box.getWidth()));
            } else {
                scaled.setHeight(box.getHeight());
                scaled.setWidth(aspectRatio.calculateWidthForHeight(box.getHeight()));
            }
            if (!ImageServerConversionUtils.fitsIn(scaled, box)) {
                if (aspectRatio.isLargerOnWidth()) {
                    scaled.setHeight(box.getHeight());
                    scaled.setWidth(aspectRatio.calculateWidthForHeight(box.getHeight()));
                } else {
                    scaled.setWidth(box.getWidth());
                    scaled.setHeight(aspectRatio.calculateHeightForWidth(box.getWidth()));
                }
            }
        }
        return scaled;
    }

    public static boolean fitsIn(DimensionsDto original, DimensionsDto boundaries) {
        return original.getWidth() <= boundaries.getWidth() && original.getHeight() <= boundaries.getHeight();
    }

    public static boolean isWithinBox(CropDto crop, DimensionsDto box) {
        return crop.getX() >= 0 && crop.getY() >= 0 && ImageServerConversionUtils.fitsIn(crop.getDimensions(), box) && crop.getX() + crop.getWidth() <= box.getWidth() && crop.getY() + crop.getHeight() <= box.getHeight();
    }

    public static int calculateDistance(ImageResolutionDto from, ImageResolutionDto to) {
        return ImageServerConversionUtils.calculateDistance(from.getDimensions(), to.getDimensions());
    }

    public static int calculateDistance(@NonNull DimensionsDto from, @NonNull DimensionsDto to) {
        if (from == null) {
            throw new IllegalArgumentException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to is marked non-null but is null");
        }
        Assert.isTrue((from.getWidth() > 0 && from.getHeight() > 0 && to.getWidth() > 0 && to.getHeight() > 0 ? 1 : 0) != 0, (String)"Width and Height must be greater than 0");
        if (from.equals(to)) {
            return 0;
        }
        if (ImageServerConversionUtils.fitsIn(from, to)) {
            return Math.abs(to.getWidth() * to.getHeight() - from.getWidth() * from.getHeight());
        }
        int distance = -Math.abs(to.getWidth() * to.getHeight() - from.getWidth() * from.getHeight());
        return distance == 0 ? -1 : distance;
    }
}

