/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.code;

import com.foreach.common.spring.code.MappedStringEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.springframework.util.Assert;

public class CodeGenerator {
    private final Random random;
    private final MappedStringEncoder encoder;

    public CodeGenerator(MappedStringEncoder encoder) {
        this.encoder = encoder;
        this.random = new Random(System.currentTimeMillis());
    }

    public List<String> generate(int numberOfCodes) {
        return this.generate(numberOfCodes, true);
    }

    public List<String> generate(int numberOfCodes, boolean padToLength) {
        Assert.isTrue((numberOfCodes >= 0 ? 1 : 0) != 0);
        ArrayList<String> codes = new ArrayList<String>(numberOfCodes);
        long maxValue = this.encoder.getMaxValue();
        if ((long)(numberOfCodes - 1) > maxValue) {
            throw new IllegalArgumentException("Unable to generate " + numberOfCodes + " codes");
        }
        long slice = this.calculateSlice(maxValue, numberOfCodes);
        int randomRange = this.calculateRangeForRandom(slice);
        for (int i = 0; i < numberOfCodes; ++i) {
            int delta = this.random.nextInt(randomRange);
            long number = (long)i * slice + (long)delta;
            codes.add(this.encoder.encode(number, padToLength));
        }
        return codes;
    }

    private long calculateSlice(long maxValue, int numberOfCodes) {
        return Math.max(maxValue / (long)(numberOfCodes + 1), 1L);
    }

    private int calculateRangeForRandom(long slice) {
        if (slice > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Long.valueOf(slice).intValue();
    }

    public static CodeGenerator forCodeLength(int length) {
        MappedStringEncoder encoder = new MappedStringEncoder(length, false);
        return new CodeGenerator(encoder);
    }
}

