/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.code;

import java.math.BigInteger;
import java.util.HashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.Assert;

public class MappedStringEncoder {
    public static final int UNSIGNED = -1;
    private static final char[] DEFAULT_ENCODING_VALUES = "J3Q24EATY9U8PZDFG7H6RKMWXCVBN".toCharArray();
    private int signIndex = -1;
    private char[][] encodingMatrix = new char[0][0];
    private char[][] unsignedEncodingMatrix = new char[0][0];
    private BigInteger maxValue;
    private BigInteger[] unitValues = new BigInteger[0];

    public MappedStringEncoder() {
    }

    public MappedStringEncoder(int encodedStringLength, boolean supportNegativeValues) {
        this.buildEncodingMatrix(DEFAULT_ENCODING_VALUES, encodedStringLength, true, supportNegativeValues ? 0 : -1);
    }

    public MappedStringEncoder(int encodedStringLength, int signIndex) {
        this.buildEncodingMatrix(DEFAULT_ENCODING_VALUES, encodedStringLength, true, signIndex);
    }

    public void setEncodingMatrix(char[][] encodingMatrix) {
        this.setEncodingMatrix(encodingMatrix, -1);
    }

    public void setEncodingMatrix(char[][] encodingMatrix, int signIndex) {
        HashSet<Character> found = new HashSet<Character>();
        for (char[] anEncodingMatrix : encodingMatrix) {
            if (anEncodingMatrix == null || anEncodingMatrix.length < 1) {
                throw new IllegalArgumentException("An encoding matrix needs at least one character on every position");
            }
            for (char value : anEncodingMatrix) {
                if (found.contains(Character.valueOf(value))) {
                    throw new IllegalArgumentException("All possible values for a given position must be unique.");
                }
                found.add(Character.valueOf(value));
            }
            found.clear();
        }
        if (signIndex != -1) {
            if (encodingMatrix.length < 2) {
                throw new IllegalArgumentException("A sign index position is only supported in an encoding matrix with a minimum of 2 positions");
            }
            if (signIndex < 0 || signIndex >= encodingMatrix.length || encodingMatrix[signIndex].length < 2) {
                throw new IllegalArgumentException("A sign index position needs at least 2 values on that position");
            }
        }
        this.encodingMatrix = (char[][])ArrayUtils.clone((Object[])encodingMatrix);
        this.signIndex = signIndex;
        BigInteger total = BigInteger.ONE;
        this.unsignedEncodingMatrix = new char[encodingMatrix.length][];
        System.arraycopy(encodingMatrix, 0, this.unsignedEncodingMatrix, 0, encodingMatrix.length);
        if (signIndex != -1) {
            this.unsignedEncodingMatrix[signIndex] = new char[]{'\u0000'};
        }
        this.unitValues = new BigInteger[this.unsignedEncodingMatrix.length];
        for (int i = this.unsignedEncodingMatrix.length - 1; i >= 0; --i) {
            this.unitValues[i] = total;
            total = total.add(total.multiply(BigInteger.valueOf(this.unsignedEncodingMatrix[i].length - 1)));
        }
        this.maxValue = total.subtract(BigInteger.ONE);
    }

    public void buildEncodingMatrix(char[] columnValues, int numberOfColumns, boolean shiftColumnValues) {
        this.buildEncodingMatrix(columnValues, numberOfColumns, shiftColumnValues, -1);
    }

    public void buildEncodingMatrix(char[] columnValues, int numberOfColumns, boolean shiftColumnValues, int signColumnIndex) {
        char[][] matrix = new char[numberOfColumns][];
        char[] shiftingValues = ArrayUtils.clone((char[])columnValues);
        for (int i = 0; i < numberOfColumns; ++i) {
            matrix[i] = shiftingValues;
            shiftingValues = shiftColumnValues ? this.shift(shiftingValues) : ArrayUtils.clone((char[])columnValues);
        }
        this.setEncodingMatrix(matrix, signColumnIndex);
    }

    private char[] shift(char[] original) {
        char[] shifted = new char[original.length];
        System.arraycopy(original, 1, shifted, 0, original.length - 1);
        shifted[original.length - 1] = original[0];
        return shifted;
    }

    public String encode(long number, boolean pad) {
        int i;
        boolean negative;
        char[] code = new char[this.getCodeLength()];
        BigInteger value = BigInteger.valueOf(number);
        if (value.compareTo(BigInteger.valueOf(this.getMinValue())) < 0) {
            throw new IllegalArgumentException("Unable to encode value " + value + " as it smaller than the minimum value");
        }
        if (value.compareTo(this.maxValue) > 0) {
            throw new IllegalArgumentException("Unable to encode value " + value + " as it is too large");
        }
        boolean bl = negative = value.compareTo(BigInteger.ZERO) < 0;
        if (negative) {
            value = value.abs();
        }
        boolean charactersSet = false;
        for (i = 0; i < this.unsignedEncodingMatrix.length; ++i) {
            BigInteger[] divideAndRemainder = value.divideAndRemainder(this.unitValues[i]);
            BigInteger divide = divideAndRemainder[0];
            BigInteger remainder = divideAndRemainder[1];
            if (divide.compareTo(BigInteger.ZERO) > 0 || charactersSet || i == this.unsignedEncodingMatrix.length - 1) {
                charactersSet = true;
                code[i] = this.unsignedEncodingMatrix[i][divide.intValue()];
            }
            value = remainder;
        }
        if (this.signIndex != -1 && negative) {
            code[this.signIndex] = this.encodingMatrix[this.signIndex][1];
            for (i = this.signIndex + 1; i < code.length; ++i) {
                if (code[i] != '\u0000') continue;
                code[i] = this.unsignedEncodingMatrix[i][0];
            }
        }
        if (pad) {
            this.pad(code);
        }
        return new String(code).trim();
    }

    private void pad(char[] code) {
        for (int i = 0; i < code.length; ++i) {
            if (code[i] != '\u0000') continue;
            code[i] = i == this.signIndex ? this.encodingMatrix[i][0] : this.unsignedEncodingMatrix[i][0];
        }
    }

    public long decode(String encoded) {
        char[] code = this.parseCode(encoded);
        boolean negative = false;
        if (this.isNegativeValuesSupported()) {
            negative = ArrayUtils.indexOf((char[])this.encodingMatrix[this.signIndex], (char)code[this.signIndex]) > 0;
            code[this.signIndex] = '\u0000';
        }
        BigInteger value = BigInteger.ZERO;
        for (int i = this.unsignedEncodingMatrix.length - 1; i >= 0; --i) {
            int index = ArrayUtils.indexOf((char[])this.unsignedEncodingMatrix[i], (char)code[i]);
            if (index < 0) {
                throw new IllegalArgumentException("Illegal code value " + code[i] + " found on position " + i);
            }
            value = value.add(this.unitValues[i].multiply(BigInteger.valueOf(index)));
        }
        return negative ? value.negate().longValue() : value.longValue();
    }

    private char[] parseCode(String encoded) {
        char[] code = new char[this.getCodeLength()];
        if (encoded.length() > code.length) {
            throw new IllegalArgumentException("Encoded value is too long: " + encoded);
        }
        System.arraycopy(encoded.toCharArray(), 0, code, code.length - encoded.length(), encoded.length());
        this.pad(code);
        return code;
    }

    public int getCodeLength() {
        return this.encodingMatrix.length;
    }

    public boolean isNegativeValuesSupported() {
        return this.signIndex != -1;
    }

    public long getMaxValue() {
        if (this.encodingMatrix.length > 0) {
            if (BigInteger.valueOf(Long.MAX_VALUE).compareTo(this.maxValue) > 0) {
                return this.maxValue.longValue();
            }
            return Long.MAX_VALUE;
        }
        return -1L;
    }

    public long getMinValue() {
        return this.isNegativeValuesSupported() ? -1L * this.getMaxValue() : 0L;
    }

    public static MappedStringEncoder forMaximumValue(long maxValue, boolean supportNegativeValues) {
        Assert.isTrue((maxValue >= 0L ? 1 : 0) != 0, (String)"Maximum value must not be a negative number");
        int length = 1;
        BigInteger maxRequired = BigInteger.valueOf(maxValue);
        BigInteger maxSupported = BigInteger.valueOf(DEFAULT_ENCODING_VALUES.length);
        while (maxSupported.compareTo(maxRequired) < 0) {
            ++length;
            maxSupported = maxSupported.add(maxSupported.multiply(BigInteger.valueOf(DEFAULT_ENCODING_VALUES.length)));
        }
        if (supportNegativeValues) {
            ++length;
        }
        return new MappedStringEncoder(length, supportNegativeValues);
    }
}

