/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.context;

import com.foreach.common.spring.context.ApplicationEnvironment;
import com.foreach.common.spring.context.ApplicationInfo;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ApplicationContextInfo
implements ApplicationInfo {
    private String environmentId;
    private String applicationName;
    private String label;
    private String hostName;
    private long buildNumber;
    private Date buildDate;
    private Date startupDate = new Date();

    @Override
    public String getInstanceId() {
        return this.getApplicationId() + "-" + this.getEnvironmentId() + "-" + this.getHostName();
    }

    @Override
    public String getApplicationId() {
        return this.getApplicationName();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Deprecated
    public final void setEnvironmentLabel(String environmentLabel) {
        this.setEnvironmentId(StringUtils.upperCase((String)environmentLabel));
    }

    public final void setEnvironment(ApplicationEnvironment environment) {
        this.setEnvironmentId(environment.name());
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Override
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Override
    public String getEnvironmentName() {
        return this.getEnvironmentId();
    }

    @Deprecated
    public final ApplicationEnvironment getEnvironment() {
        return ApplicationEnvironment.valueOf(this.getEnvironmentId());
    }

    public final boolean isRunningIn(ApplicationEnvironment environmentToCheck) {
        return this.isRunningIn(environmentToCheck.name());
    }

    @Override
    public boolean isRunningIn(String environmentId) {
        return StringUtils.equalsIgnoreCase((CharSequence)environmentId, (CharSequence)this.environmentId);
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public final String getApplicationName() {
        return this.applicationName;
    }

    public final void setBuildNumber(long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public final long getBuildNumber() {
        return this.buildNumber != 0L ? this.buildNumber : this.getBuildDate().getTime();
    }

    @Override
    public String getBuildId() {
        return "" + this.getBuildNumber();
    }

    public final void setBuildDate(Date buildDate) {
        this.buildDate = buildDate;
    }

    @Override
    public final Date getBuildDate() {
        return this.buildDate != null ? this.buildDate : this.startupDate;
    }

    @Override
    public final Date getStartupDate() {
        return this.startupDate;
    }

    public final String toString() {
        return "ApplicationContextInfo{environment=" + this.getEnvironmentId() + ", label='" + this.label + '\'' + ", applicationName='" + this.applicationName + '\'' + ", buildNumber=" + this.buildNumber + ", buildDate=" + this.buildDate + ", startupDate=" + this.startupDate + '}';
    }
}

