/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.convert;

import com.foreach.common.spring.convert.RecursiveConverter;
import com.foreach.common.spring.enums.CodeLookup;
import com.foreach.common.spring.enums.EnumUtils;
import com.foreach.common.spring.enums.IdLookup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public class EnumConverterFactory
implements ConverterFactory<String, Enum>,
RecursiveConverter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConversionService conversionService;

    @Override
    public final void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public final <E extends Enum> Converter<String, E> getConverter(Class<E> targetType) {
        this.logger.debug("converter requested for type " + targetType.getName());
        if (this.conversionService == null) {
            this.logger.error("conversionService not set for EnumConverterFactory instance");
        }
        if (IdLookup.class.isAssignableFrom(targetType) || CodeLookup.class.isAssignableFrom(targetType)) {
            return new EnumConverter<E>(targetType);
        }
        return null;
    }

    private final class EnumConverter<E extends Enum>
    implements Converter<String, E> {
        private Class<E> enumType;

        public EnumConverter(Class<E> enumType) {
            this.enumType = enumType;
        }

        public E convert(String source) {
            E attempt;
            Class intermediateType;
            if (IdLookup.class.isAssignableFrom(this.enumType)) {
                EnumConverterFactory.this.logger.debug("attempting to convert " + source + " to " + this.enumType + " using IdLookup");
                intermediateType = this.lookupMethodParameterClass(this.enumType, IdLookup.class);
                if (intermediateType == null) {
                    EnumConverterFactory.this.logger.error("IdLookup parameter type not specified, assuming Integer.");
                    intermediateType = Integer.class;
                }
                if ((attempt = this.tryConvertUsingMethod(source, intermediateType, "getById")) != null) {
                    return attempt;
                }
            }
            if (CodeLookup.class.isAssignableFrom(this.enumType)) {
                EnumConverterFactory.this.logger.debug("attempting to convert " + source + " to " + this.enumType + " using CodeLookup");
                intermediateType = this.lookupMethodParameterClass(this.enumType, CodeLookup.class);
                if (intermediateType == null) {
                    EnumConverterFactory.this.logger.error("CodeLookup parameter type not specified, assuming String.");
                    intermediateType = String.class;
                }
                if ((attempt = this.tryConvertUsingMethod(source, intermediateType, "getByCode")) != null) {
                    return attempt;
                }
            }
            return null;
        }

        private Class lookupMethodParameterClass(Class targetClass, Class lookupInterface) {
            Type[] ts;
            for (Type t : ts = targetClass.getGenericInterfaces()) {
                ParameterizedType pt;
                if (!(t instanceof ParameterizedType) || !(pt = (ParameterizedType)t).getRawType().equals(lookupInterface)) continue;
                return (Class)pt.getActualTypeArguments()[0];
            }
            return null;
        }

        private E tryConvertUsingMethod(String source, Class intermediateType, String lookupMethodName) {
            try {
                Object id = source;
                EnumConverterFactory.this.logger.debug("performing intermediate conversion of " + source + " to " + intermediateType);
                if (!String.class.isAssignableFrom(intermediateType)) {
                    id = EnumConverterFactory.this.conversionService.convert((Object)source, TypeDescriptor.valueOf(String.class), TypeDescriptor.valueOf((Class)intermediateType));
                }
                Method m = EnumUtils.class.getMethod(lookupMethodName, Class.class, Object.class);
                return (E)((Enum)m.invoke(EnumUtils.class, this.enumType, id));
            }
            catch (NoSuchMethodException nsme) {
                EnumConverterFactory.this.logger.error(nsme.getMessage(), (Throwable)nsme);
            }
            catch (IllegalAccessException iae) {
                EnumConverterFactory.this.logger.error(iae.getMessage(), (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                EnumConverterFactory.this.logger.error(ite.getMessage(), (Throwable)ite);
            }
            catch (ConversionFailedException conversionFailedException) {
                // empty catch block
            }
            EnumConverterFactory.this.logger.error("intermediate conversion failed");
            return null;
        }
    }
}

