/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.convert;

import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;

public class HierarchicalConversionService
extends GenericConversionService {
    private ConversionService parent;

    public HierarchicalConversionService() {
    }

    public HierarchicalConversionService(ConversionService parent) {
        this.parent = parent;
    }

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    public ConversionService getParent() {
        return this.parent;
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        boolean possible = super.canConvert(sourceType, targetType);
        if (!possible && this.parent != null) {
            possible = this.parent.canConvert(sourceType, targetType);
        }
        return possible;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (this.parent == null || super.canConvert(sourceType, targetType)) {
            return super.convert(source, sourceType, targetType);
        }
        return this.parent.convert(source, sourceType, targetType);
    }

    public static HierarchicalConversionService defaultConversionService() {
        return HierarchicalConversionService.defaultConversionService(null);
    }

    public static HierarchicalConversionService defaultConversionService(ConversionService parent) {
        HierarchicalConversionService conversionService = new HierarchicalConversionService(parent);
        DefaultConversionService.addDefaultConverters((ConverterRegistry)conversionService);
        return conversionService;
    }
}

