/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.enums;

import com.foreach.common.spring.enums.CodeLookup;
import com.foreach.common.spring.enums.IdLookup;
import java.util.ArrayList;
import java.util.List;

public class EnumUtils {
    protected EnumUtils() {
    }

    public static <I, E extends Enum<E>> E getById(Class<E> clazz, I id) {
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!((IdLookup)((Object)e)).getId().equals(id)) continue;
            return (E)e;
        }
        return null;
    }

    public static <S, E extends Enum<E>> E getByCode(Class<E> clazz, S code) {
        if (code instanceof String) {
            return EnumUtils.getByCaseInsensitiveString(clazz, code);
        }
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!((CodeLookup)((Object)e)).getCode().equals(code)) continue;
            return (E)e;
        }
        return null;
    }

    public static <I, E extends Enum<E>> List<E> getByIds(Class<E> clazz, List<I> ids) {
        ArrayList<E> result = new ArrayList<E>();
        for (I id : ids) {
            E e = EnumUtils.getById(clazz, id);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    private static <S, E extends Enum<E>> E getByCaseInsensitiveString(Class<E> clazz, S code) {
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!((String)((CodeLookup)((Object)e)).getCode()).equalsIgnoreCase((String)code)) continue;
            return (E)e;
        }
        return null;
    }
}

