/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.localization;

import com.foreach.common.spring.localization.Language;
import com.foreach.common.spring.localization.LanguageConfigurator;
import com.foreach.common.spring.localization.LocalizedFields;
import com.foreach.common.spring.localization.LocalizedFieldsCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLocalizedFieldsObject<Base extends LocalizedFields> {
    private final Map<String, Base> fieldsByLanguageCode = new HashMap<String, Base>();
    private Map<String, Base> fieldsAsUnmodifiableMap = null;
    private Collection<Base> fieldsAsModifiableCollection = null;

    protected AbstractLocalizedFieldsObject() {
        this.createDefaultFields();
    }

    public final Map<String, Base> getFields() {
        if (this.fieldsAsUnmodifiableMap == null) {
            this.fieldsAsUnmodifiableMap = Collections.unmodifiableMap(this.fieldsByLanguageCode);
        }
        return this.fieldsAsUnmodifiableMap;
    }

    public final void setFieldsAsCollection(Collection<Base> allFields) {
        Collection<Base> current = this.getFieldsAsCollection();
        current.clear();
        current.addAll(allFields);
    }

    public final Collection<Base> getFieldsAsCollection() {
        if (this.fieldsAsModifiableCollection == null) {
            this.fieldsAsModifiableCollection = new LocalizedFieldsCollection<Base>(this.fieldsByLanguageCode);
        }
        return this.fieldsAsModifiableCollection;
    }

    public final Base getFieldsForLanguage(Language language) {
        Object fields;
        String languageCode = (String)language.getCode();
        if (this.fieldsByLanguageCode.containsKey(languageCode)) {
            fields = (LocalizedFields)this.fieldsByLanguageCode.get(languageCode);
        } else {
            fields = this.createFields(language);
            if (fields != null) {
                this.addFields(fields);
            }
        }
        return fields;
    }

    public final void addFields(Base fields) {
        if (fields.getLanguage() == null) {
            throw new RuntimeException("Language is required on LocalizedFields");
        }
        this.fieldsByLanguageCode.put((String)fields.getLanguage().getCode(), fields);
    }

    public final void removeFields(Language language) {
        if (language != null && this.fieldsByLanguageCode.containsKey(language.getCode())) {
            this.fieldsByLanguageCode.remove(language.getCode());
        }
    }

    private void createDefaultFields() {
        for (Language language : LanguageConfigurator.getLanguages()) {
            this.getFieldsForLanguage(language);
        }
    }

    public abstract Base createFields(Language var1);
}

