/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.localization;

import com.foreach.common.spring.enums.EnumUtils;
import com.foreach.common.spring.localization.Language;

public final class LanguageConfigurator {
    private static Class languageClass;

    public <E extends Enum<E>> LanguageConfigurator(Class<E> languageClass) {
        LanguageConfigurator.languageClass = languageClass;
    }

    public static Language getLanguageByCode(String code) {
        if (languageClass == null) {
            throw new LanguagesNotConfiguredException();
        }
        return (Language)EnumUtils.getByCode(languageClass, code);
    }

    public static Language[] getLanguages() {
        if (languageClass == null) {
            throw new LanguagesNotConfiguredException();
        }
        return (Language[])languageClass.getEnumConstants();
    }

    public static Class getLanguageClass() {
        return languageClass;
    }

    public static final class LanguagesNotConfiguredException
    extends RuntimeException {
        private LanguagesNotConfiguredException() {
            super("Languages have not been configured, please initialize the system by creating a LanguageConfigurator first.");
        }
    }
}

