/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.localization;

import com.foreach.common.spring.localization.LocalizedFields;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public final class LocalizedFieldsCollection<Base extends LocalizedFields>
implements Collection<Base> {
    private final Map<String, Base> fieldsMap;

    LocalizedFieldsCollection(Map<String, Base> fieldsMap) {
        this.fieldsMap = fieldsMap;
    }

    @Override
    public int size() {
        return this.fieldsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fieldsMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.fieldsMap.containsValue(o);
    }

    @Override
    public Iterator<Base> iterator() {
        return this.fieldsMap.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.fieldsMap.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.fieldsMap.values().toArray(a);
    }

    @Override
    public boolean add(Base base) {
        if (base.getLanguage() != null) {
            this.fieldsMap.put((String)base.getLanguage().getCode(), base);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        boolean found = false;
        String languageCode = null;
        for (Map.Entry<String, Base> entry : this.fieldsMap.entrySet()) {
            if (!((LocalizedFields)entry.getValue()).equals(o)) continue;
            languageCode = entry.getKey();
            found = true;
        }
        LocalizedFields base = found ? (LocalizedFields)this.fieldsMap.remove(languageCode) : null;
        return base != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.fieldsMap.entrySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Base> c) {
        for (LocalizedFields b : c) {
            this.add((Base)b);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean success = true;
        for (Object o : c) {
            if (this.remove(o)) continue;
            success = false;
        }
        return success;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.fieldsMap.entrySet().retainAll(c);
    }

    @Override
    public void clear() {
        this.fieldsMap.clear();
    }
}

