/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.localization.text;

import com.foreach.common.concurrent.SynchronousTaskExecutor;
import com.foreach.common.concurrent.locks.ObjectLock;
import com.foreach.common.concurrent.locks.ObjectLockRepository;
import com.foreach.common.concurrent.locks.ReentrantObjectLockRepository;
import com.foreach.common.spring.localization.Language;
import com.foreach.common.spring.localization.LanguageConfigurator;
import com.foreach.common.spring.localization.text.LocalizedText;
import com.foreach.common.spring.localization.text.LocalizedTextDataStore;
import com.foreach.common.spring.localization.text.LocalizedTextFields;
import com.foreach.common.spring.localization.text.LocalizedTextService;
import com.foreach.common.spring.localization.text.LocalizedTextSet;
import com.foreach.common.spring.localization.text.LocalizedTextSetCache;
import com.foreach.common.spring.localization.text.LocalizedTextSetImpl;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public abstract class AbstractLocalizedTextService
implements LocalizedTextService {
    protected final Logger LOG;
    private final ObjectLockRepository<String> textSetFetchLocks = new ReentrantObjectLockRepository();
    private final LocalizedTextDataStore localizedTextDao;
    private ExecutorService executorService = new SynchronousTaskExecutor();
    private LocalizedTextSetCache textSetCache = new NoCachingLocalizedTextSetCache();

    protected AbstractLocalizedTextService(LocalizedTextDataStore localizedTextDao) {
        this.localizedTextDao = localizedTextDao;
        this.LOG = Logger.getLogger(this.getClass());
    }

    public final void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        if (this.executorService == null) {
            this.executorService = new SynchronousTaskExecutor();
        }
    }

    public final void setTextSetCache(LocalizedTextSetCache textSetCache) {
        this.textSetCache = textSetCache;
        if (this.textSetCache == null) {
            this.textSetCache = new NoCachingLocalizedTextSetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LocalizedTextSet getLocalizedTextSet(String application, String group) {
        LocalizedTextSet textSet = this.textSetCache.getLocalizedTextSet(application, group);
        if (textSet == null) {
            ObjectLock writeLock = this.textSetFetchLocks.getLock((Object)(application + group));
            try {
                writeLock.lock();
                textSet = this.textSetCache.getLocalizedTextSet(application, group);
                if (textSet == null) {
                    textSet = new LocalizedTextSetImpl(application, group, this);
                    this.textSetCache.storeLocalizedTextSet(textSet);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return textSet;
    }

    @Override
    public final List<LocalizedText> getLocalizedTextItems(String application, String group) {
        return this.localizedTextDao.getLocalizedTextForGroup(application, group);
    }

    @Override
    public final void flagAsUsed(final LocalizedText text) {
        text.setUsed(true);
        text.setUpdated(new Date());
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractLocalizedTextService.this.localizedTextDao.flagAsUsed(text);
                }
                catch (RuntimeException re) {
                    AbstractLocalizedTextService.this.LOG.error((Object)("Failed to flag item as used: " + text), (Throwable)re);
                }
            }
        });
    }

    @Override
    public final synchronized LocalizedText saveDefaultText(String application, String group, String label, String defaultValue) {
        LocalizedText existing = this.localizedTextDao.getLocalizedText(application, group, label);
        if (existing != null) {
            this.LOG.debug((Object)("Not creating text item with defaults because it already exists: " + existing));
            return existing;
        }
        LocalizedText text = new LocalizedText();
        text.setApplication(application);
        text.setGroup(group);
        text.setLabel(label);
        for (Language language : LanguageConfigurator.getLanguages()) {
            ((LocalizedTextFields)text.getFieldsForLanguage(language)).setText(defaultValue);
        }
        text.setUsed(true);
        text.setAutoGenerated(true);
        text.setCreated(new Date());
        this.LOG.debug((Object)("Creating new text item with defaults: " + text));
        try {
            this.localizedTextDao.insertLocalizedText(text);
        }
        catch (RuntimeException re) {
            this.LOG.error((Object)"Insert of new text item failed ", (Throwable)re);
        }
        return text;
    }

    @Override
    public final LocalizedText getLocalizedText(String application, String group, String label) {
        return this.localizedTextDao.getLocalizedText(application, group, label);
    }

    @Override
    public final void saveLocalizedText(final LocalizedText text) {
        if (text != null) {
            LocalizedText existing = this.getLocalizedText(text.getApplication(), text.getGroup(), text.getLabel());
            if (existing == null) {
                this.localizedTextDao.insertLocalizedText(text);
            } else {
                this.localizedTextDao.updateLocalizedText(text);
            }
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractLocalizedTextService.this.textSetCache.reload(text.getApplication(), text.getGroup());
                    }
                    catch (RuntimeException re) {
                        AbstractLocalizedTextService.this.LOG.error((Object)"Failed to reload cache ", (Throwable)re);
                    }
                }
            });
        }
    }

    @Override
    public final List<LocalizedText> searchLocalizedTextItemsForText(String textToSearchFor) {
        return this.localizedTextDao.searchLocalizedText(textToSearchFor);
    }

    @Override
    public final List<String> getApplications() {
        return this.localizedTextDao.getApplications();
    }

    @Override
    public final List<String> getGroups(String application) {
        return this.localizedTextDao.getGroups(application);
    }

    @Override
    public final void deleteLocalizedText(final LocalizedText text) {
        if (text != null) {
            this.localizedTextDao.deleteLocalizedText(text);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractLocalizedTextService.this.textSetCache.reload(text.getApplication(), text.getGroup());
                    }
                    catch (RuntimeException re) {
                        AbstractLocalizedTextService.this.LOG.error((Object)"Failed to reload cache ", (Throwable)re);
                    }
                }
            });
        }
    }

    @Override
    public final Map<String, String> getLanguageMap(LocalizedTextSet localizedTextSet, Language language) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (LocalizedText localizedText : localizedTextSet.getItems()) {
            String value = ((LocalizedTextFields)localizedText.getFieldsForLanguage(language)).getText();
            result.put(localizedText.getLabel(), value);
        }
        return result;
    }

    private static final class NoCachingLocalizedTextSetCache
    implements LocalizedTextSetCache {
        private NoCachingLocalizedTextSetCache() {
        }

        @Override
        public LocalizedTextSet getLocalizedTextSet(String application, String group) {
            return null;
        }

        @Override
        public void storeLocalizedTextSet(LocalizedTextSet textSet) {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public void reload() {
        }

        @Override
        public void reload(String application, String group) {
        }

        @Override
        public Set<LocalizedTextSet> getCachedTextSets() {
            return Collections.emptySet();
        }
    }
}

