/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.localization.text;

import com.foreach.common.spring.localization.text.LocalizedTextSet;
import com.foreach.common.spring.localization.text.LocalizedTextSetCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EternalLocalizedTextSetCache
implements LocalizedTextSetCache {
    private Map<String, LocalizedTextSet> cache = Collections.synchronizedMap(new HashMap());

    @Override
    public final LocalizedTextSet getLocalizedTextSet(String application, String group) {
        return this.cache.get(this.cacheKey(application, group));
    }

    @Override
    public final void storeLocalizedTextSet(LocalizedTextSet textSet) {
        if (textSet != null) {
            this.cache.put(this.cacheKey(textSet.getApplication(), textSet.getGroup()), textSet);
        }
    }

    private String cacheKey(String application, String group) {
        return application + group;
    }

    @Override
    public final int size() {
        return this.cache.size();
    }

    @Override
    public final void clear() {
        this.cache.clear();
    }

    @Override
    public final void reload() {
        for (LocalizedTextSet set : new HashSet<LocalizedTextSet>(this.cache.values())) {
            set.reload();
        }
    }

    @Override
    public final void reload(String application, String group) {
        LocalizedTextSet cachedSet = this.getLocalizedTextSet(application, group);
        if (cachedSet != null) {
            cachedSet.reload();
        }
    }

    @Override
    public final Set<LocalizedTextSet> getCachedTextSets() {
        return new HashSet<LocalizedTextSet>(this.cache.values());
    }
}

