/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.localization.text;

import com.foreach.common.spring.localization.AbstractLocalizedFieldsObject;
import com.foreach.common.spring.localization.Language;
import com.foreach.common.spring.localization.text.LocalizedTextFields;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LocalizedText
extends AbstractLocalizedFieldsObject<LocalizedTextFields>
implements Comparable<LocalizedText> {
    private String application;
    private String group;
    private String label;
    private boolean used;
    private boolean autoGenerated;
    private Date created;
    private Date updated;

    public final String getGroup() {
        return this.group;
    }

    public final void setGroup(String group) {
        this.group = group;
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public final boolean isUsed() {
        return this.used;
    }

    public final void setUsed(boolean used) {
        this.used = used;
    }

    public final String getApplication() {
        return this.application;
    }

    public final void setApplication(String application) {
        this.application = application;
    }

    public final boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public final void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    public final Date getCreated() {
        return this.created;
    }

    public final void setCreated(Date created) {
        this.created = created;
    }

    public final Date getUpdated() {
        return this.updated;
    }

    public final void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Override
    public final LocalizedTextFields createFields(Language language) {
        return new LocalizedTextFields(language);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedText that = (LocalizedText)o;
        if (this.application != null ? !this.application.equals(that.application) : that.application != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        return !(this.label != null ? !this.label.equals(that.label) : that.label != null);
    }

    public int hashCode() {
        int result = this.application != null ? this.application.hashCode() : 0;
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        return result;
    }

    public final String toString() {
        return "{" + this.application + "-" + this.group + ": " + this.label + "}";
    }

    @Override
    public int compareTo(LocalizedText o) {
        String thisValue = this.toString();
        String thatValue = o.toString();
        return thisValue.compareTo(thatValue);
    }

    public static LocalizedTextBuilder builder() {
        return new LocalizedTextBuilder();
    }

    public static class LocalizedTextBuilder {
        private String application;
        private String group;
        private String label;
        private Map<Language, String> localizedTextFieldMap = new HashMap<Language, String>();

        LocalizedTextBuilder() {
        }

        public LocalizedTextBuilder group(String group) {
            this.group = group;
            return this;
        }

        public LocalizedTextBuilder application(String application) {
            this.application = application;
            return this;
        }

        public LocalizedTextBuilder label(String label) {
            this.label = label;
            return this;
        }

        public LocalizedTextBuilder field(Language language, String field) {
            this.localizedTextFieldMap.put(language, field);
            return this;
        }

        public LocalizedText build() {
            LocalizedText localizedText = new LocalizedText();
            localizedText.setGroup(this.group);
            localizedText.setLabel(this.label);
            localizedText.setApplication(this.application);
            for (Language l : this.localizedTextFieldMap.keySet()) {
                LocalizedTextFields localizedTextFields = new LocalizedTextFields(l);
                localizedTextFields.setText(this.localizedTextFieldMap.get(l));
                localizedText.addFields(localizedTextFields);
            }
            return localizedText;
        }
    }
}

