/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.localization.text;

import com.foreach.common.spring.localization.Language;
import com.foreach.common.spring.localization.text.LocalizedText;
import com.foreach.common.spring.localization.text.LocalizedTextFields;
import com.foreach.common.spring.localization.text.LocalizedTextService;
import com.foreach.common.spring.localization.text.LocalizedTextSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalizedTextSetImpl
implements LocalizedTextSet {
    private final String application;
    private final String group;
    private final LocalizedTextService localizedTextService;
    private Map<String, LocalizedText> textMap = new HashMap<String, LocalizedText>();

    protected LocalizedTextSetImpl(String application, String group, LocalizedTextService localizedTextService) {
        this.application = application;
        this.group = group;
        this.localizedTextService = localizedTextService;
        this.reload();
    }

    @Override
    public final String getApplication() {
        return this.application;
    }

    @Override
    public final String getGroup() {
        return this.group;
    }

    final LocalizedTextService getLocalizedTextService() {
        return this.localizedTextService;
    }

    @Override
    public final Collection<LocalizedText> getItems() {
        return this.textMap.values();
    }

    @Override
    public final String getText(String label, Language language) {
        return this.getText(label, language, null);
    }

    @Override
    public final String getText(String label, Language language, String defaultValue) {
        return this.getText(label, language, defaultValue, true);
    }

    @Override
    public String getText(String label, Language language, String defaultValue, boolean storeDefault) {
        LocalizedText text = this.textMap.get(label);
        if (text == null && storeDefault) {
            text = this.localizedTextService.saveDefaultText(this.application, this.group, label, defaultValue);
            this.textMap.put(text.getLabel(), text);
        }
        String result = null;
        if (text != null) {
            if (!text.isUsed()) {
                text.setUsed(true);
                this.localizedTextService.flagAsUsed(text);
            }
            result = ((LocalizedTextFields)text.getFieldsForLanguage(language)).getText();
        }
        return result;
    }

    @Override
    public final boolean exists(String label) {
        return this.textMap.containsKey(label);
    }

    @Override
    public final int size() {
        return this.textMap.size();
    }

    @Override
    public final void reload() {
        HashMap<String, LocalizedText> updatedMap = new HashMap<String, LocalizedText>();
        List<LocalizedText> items = this.localizedTextService.getLocalizedTextItems(this.application, this.group);
        for (LocalizedText text : items) {
            updatedMap.put(text.getLabel(), text);
        }
        this.textMap = updatedMap;
    }
}

