/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.foreach.common.spring.logging.LogbackConfigurerException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public abstract class LogbackConfigurerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    protected LogbackConfigurerAdapter() {
    }

    @PostConstruct
    public void configure() {
        LinkedList<Resource> configurationResources = new LinkedList<Resource>();
        this.LOG.info("Initializing logging system with logback configuration files");
        this.addConfigurationResources(configurationResources);
        if (!configurationResources.isEmpty()) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            this.configureLoggerContext(loggerContext);
            HashMap<String, String> properties = new HashMap<String, String>();
            this.addProperties(properties);
            for (Map.Entry entry : properties.entrySet()) {
                loggerContext.putProperty((String)entry.getKey(), (String)entry.getValue());
            }
            this.parseResources(loggerContext, configurationResources);
        }
    }

    protected void configureLoggerContext(LoggerContext context) {
    }

    protected void addConfigurationResources(Collection<Resource> resources) {
    }

    protected void addProperties(Map<String, String> properties) {
    }

    private void parseResources(LoggerContext context, Collection<Resource> resources) {
        for (Resource resource : resources) {
            if (resource == null || !resource.exists()) continue;
            this.LOG.info("Applying logback configuration {}", (Object)resource);
            this.parseLogbackFile(context, resource);
        }
    }

    private void parseLogbackFile(LoggerContext loggerContext, Resource file) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        try {
            joranConfigurator.setContext((Context)loggerContext);
            joranConfigurator.doConfigure(file.getInputStream());
        }
        catch (JoranException jex) {
            this.LOG.warn("Exception parsing logback configuration {}: {}", (Object)file, (Object)jex);
        }
        catch (Exception e) {
            throw new LogbackConfigurerException(e);
        }
    }
}

