/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.logging;

import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodExecutionTimeLogger {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int minimumDuration = 75;

    protected final void setLogger(Logger log) {
        this.logger = log;
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    public final void setMinimumDuration(int time) {
        this.minimumDuration = time;
    }

    protected final Object proceedAndLogExecutionTime(ProceedingJoinPoint point) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = point.proceed();
        long duration = System.currentTimeMillis() - startTime;
        if (duration > (long)this.minimumDuration) {
            String method = "";
            try {
                method = point.getSignature().getDeclaringType().getName() + "." + point.getSignature().getName();
                this.logger.info("" + method + "\t" + duration);
            }
            catch (Exception e) {
                this.logger.warn("unable-to-get-method-signature\n" + duration);
            }
        }
        return result;
    }
}

