/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.mail;

import com.foreach.common.concurrent.PreComputedFuture;
import com.foreach.common.concurrent.SynchronousTaskExecutor;
import com.foreach.common.spring.mail.MailService;
import com.foreach.common.spring.mail.MailStatus;
import com.foreach.common.spring.validators.MultipleEmailsValidator;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class BasicMailService
implements MailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private JavaMailSender javaMailSender;
    private String originator;
    private String serviceBccRecipients;
    private ExecutorService executorService = new SynchronousTaskExecutor();

    protected final void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    public final void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public final void setOriginator(String originator) {
        this.originator = originator;
    }

    public final void setServiceBccRecipients(String serviceBccRecipients) {
        this.serviceBccRecipients = serviceBccRecipients;
    }

    public final String getServiceBccRecipients() {
        return this.serviceBccRecipients;
    }

    public final synchronized void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public final synchronized ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public final Future<MailStatus> sendMimeMail(String from, String to, String bccs, String subject, String body, Map<String, File> attachments) {
        Logger log = this.getLogger();
        try {
            MimeMessage message = this.createMimeMessage(from, to, bccs, subject, body, attachments);
            log.info("Sending html email " + from + " > " + to + ": " + subject);
            return this.sendMail(message);
        }
        catch (MessagingException e) {
            log.error("Failed to compose mail ", (Throwable)e);
            return new PreComputedFuture((Object)new MailStatus(false, e));
        }
    }

    private MimeMessage createMimeMessage(String from, String to, String bccs, String subject, String body, Map<String, File> attachments) throws MessagingException {
        String bccRecipients;
        MimeMessage message = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, attachments != null);
        helper.setTo(this.getToAddresses(to));
        helper.setFrom(from == null ? this.originator : from);
        helper.setText(body, true);
        message.setSubject(subject);
        String string = bccRecipients = bccs == null ? this.serviceBccRecipients : bccs;
        if (bccRecipients != null) {
            helper.setBcc(this.getToAddresses(bccRecipients));
        }
        if (attachments != null) {
            for (Map.Entry<String, File> entry : attachments.entrySet()) {
                helper.addAttachment(entry.getKey(), entry.getValue());
            }
        }
        return message;
    }

    private Future<MailStatus> sendMail(final MimeMessage message) {
        return this.getExecutorService().submit(new Callable<MailStatus>(){

            @Override
            public MailStatus call() throws Exception {
                try {
                    BasicMailService.this.javaMailSender.send(message);
                    return new MailStatus(true);
                }
                catch (Exception e) {
                    BasicMailService.this.getLogger().error("Failed to send message ", (Throwable)e);
                    return new MailStatus(false, e);
                }
            }
        });
    }

    private String[] getToAddresses(String to) {
        List<String> emailList = MultipleEmailsValidator.separateEmailAddresses(to);
        return emailList.toArray(new String[emailList.size()]);
    }
}

