/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.properties;

import com.foreach.common.spring.properties.PropertyTypeRegistry;
import com.foreach.common.spring.properties.TypedPropertyMap;
import java.util.HashMap;
import java.util.Map;

public class CachingTypedPropertyMap<T>
extends TypedPropertyMap<T> {
    private Map<T, Object> cachedValues = new HashMap<T, Object>();

    public CachingTypedPropertyMap(PropertyTypeRegistry<T> propertyTypeRegistry, Map<T, ?> source, Class sourceValueClass) {
        super(propertyTypeRegistry, source, sourceValueClass);
    }

    @Override
    public <O> O getValue(T property) {
        if (!this.cachedValues.containsKey(property)) {
            Object value = super.getValue(property);
            this.cachedValues.put(property, value);
        }
        return (O)this.cachedValues.get(property);
    }

    @Override
    public Object set(T property, Object value) {
        this.cachedValues.remove(property);
        return super.set(property, value);
    }

    @Override
    public void clear() {
        this.cachedValues.clear();
        super.clear();
    }

    @Override
    public Object remove(Object key) {
        this.cachedValues.remove(key);
        return super.remove(key);
    }

    public void refresh() {
        this.cachedValues.clear();
    }

    @Override
    public TypedPropertyMap<T> detach() {
        HashMap sourceCopy = new HashMap();
        for (Map.Entry entry : this.entrySet()) {
            sourceCopy.put(entry.getKey(), entry.getValue());
        }
        return new CachingTypedPropertyMap(this.propertyTypeRegistry, sourceCopy, this.sourceValueClass);
    }
}

