/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.properties;

import com.foreach.common.spring.properties.PropertyFactory;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;

public class PropertyTypeRegistry<T> {
    private final Map<T, PropertyTypeRecord> definitions = new TreeMap<T, PropertyTypeRecord>();
    private Class classForUnknownProperties = String.class;
    private ConversionService defaultConversionService;

    public PropertyTypeRegistry() {
    }

    public PropertyTypeRegistry(ConversionService conversionService) {
        this(String.class, conversionService);
    }

    public PropertyTypeRegistry(Class classForUnknownProperties) {
        this(classForUnknownProperties, null);
    }

    public PropertyTypeRegistry(Class classForUnknownProperties, ConversionService conversionService) {
        this.classForUnknownProperties = classForUnknownProperties;
        this.setDefaultConversionService(conversionService);
    }

    public void setDefaultConversionService(ConversionService defaultConversionService) {
        this.defaultConversionService = defaultConversionService;
    }

    public ConversionService getDefaultConversionService() {
        return this.defaultConversionService;
    }

    public void register(T propertyKey, Class propertyClass) {
        this.register(propertyKey, propertyClass, null);
    }

    public void register(T propertyKey, TypeDescriptor propertyType) {
        this.register(propertyKey, propertyType, null);
    }

    public <A> void register(T propertyKey, Class<A> propertyClass, PropertyFactory<T, A> defaultValueFactory) {
        this.register(propertyKey, TypeDescriptor.valueOf(propertyClass), defaultValueFactory, null);
    }

    public void register(T propertyKey, TypeDescriptor propertyType, PropertyFactory<T, ?> defaultValueFactory) {
        this.definitions.put(propertyKey, new PropertyTypeRecord(propertyType, defaultValueFactory, null));
    }

    public <A> void register(T propertyKey, Class<A> propertyClass, PropertyFactory<T, A> defaultValueFactory, ConversionService conversionService) {
        this.register(propertyKey, TypeDescriptor.valueOf(propertyClass), defaultValueFactory, conversionService);
    }

    public void register(T propertyKey, TypeDescriptor propertyType, PropertyFactory<T, ?> defaultValueFactory, ConversionService conversionService) {
        this.definitions.put(propertyKey, new PropertyTypeRecord(propertyType, defaultValueFactory, conversionService));
    }

    public void unregister(T propertyKey) {
        this.definitions.remove(propertyKey);
    }

    public TypeDescriptor getTypeForProperty(T propertyKey) {
        PropertyTypeRecord actual = this.definitions.get(propertyKey);
        if (actual != null) {
            return actual.getPropertyType();
        }
        return TypeDescriptor.valueOf((Class)this.getClassForUnknownProperties());
    }

    public Class getClassForProperty(T propertyKey) {
        PropertyTypeRecord actual = this.definitions.get(propertyKey);
        if (actual != null) {
            return actual.getPropertyType().getType();
        }
        return this.getClassForUnknownProperties();
    }

    public Object getDefaultValueForProperty(T propertyKey) {
        PropertyFactory factory;
        PropertyTypeRecord actual = this.definitions.get(propertyKey);
        if (actual != null && (factory = actual.getDefaultValueFactory()) != null) {
            return factory.create(this, propertyKey);
        }
        return null;
    }

    public ConversionService getConversionServiceForProperty(T propertyKey) {
        PropertyTypeRecord actual = this.definitions.get(propertyKey);
        ConversionService conversionService = null;
        if (actual != null) {
            conversionService = actual.getConversionService();
        }
        return conversionService != null ? conversionService : this.defaultConversionService;
    }

    public Class getClassForUnknownProperties() {
        if (this.classForUnknownProperties == null) {
            throw new RuntimeException("No class registered for unknown properties.");
        }
        return this.classForUnknownProperties;
    }

    public void setClassForUnknownProperties(Class classForUnknownProperties) {
        this.classForUnknownProperties = classForUnknownProperties;
    }

    public boolean isRegistered(T propertyKey) {
        return this.definitions.containsKey(propertyKey);
    }

    public Collection<T> getRegisteredProperties() {
        return this.definitions.keySet();
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    public void clear() {
        this.definitions.clear();
    }

    private static class PropertyTypeRecord {
        private final TypeDescriptor propertyType;
        private final PropertyFactory defaultValueFactory;
        private final ConversionService conversionService;

        private PropertyTypeRecord(TypeDescriptor propertyType, PropertyFactory defaultValueFactory, ConversionService conversionService) {
            this.propertyType = propertyType;
            this.defaultValueFactory = defaultValueFactory;
            this.conversionService = conversionService;
        }

        public TypeDescriptor getPropertyType() {
            return this.propertyType;
        }

        public PropertyFactory getDefaultValueFactory() {
            return this.defaultValueFactory;
        }

        public ConversionService getConversionService() {
            return this.conversionService;
        }
    }
}

