/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.properties;

import com.foreach.common.spring.properties.PropertiesSource;
import com.foreach.common.spring.properties.PropertyTypeRegistry;
import com.foreach.common.spring.properties.support.DirectPropertiesSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;

public class TypedPropertyMap<T>
implements Map<T, Object>,
Cloneable {
    protected final PropertyTypeRegistry<T> propertyTypeRegistry;
    protected final Class sourceValueClass;
    protected final PropertiesSource source;

    public TypedPropertyMap(PropertyTypeRegistry<T> propertyTypeRegistry, Map<T, ?> source, Class sourceValueClass) {
        this.propertyTypeRegistry = propertyTypeRegistry;
        this.source = new DirectPropertiesSource<T>(source);
        this.sourceValueClass = sourceValueClass;
    }

    public PropertiesSource getSource() {
        return this.source;
    }

    public TypedPropertyMap(PropertyTypeRegistry<T> propertyTypeRegistry, PropertiesSource source, Class sourceValueClass) {
        this.propertyTypeRegistry = propertyTypeRegistry;
        this.source = source;
        this.sourceValueClass = sourceValueClass;
    }

    public <O> O getValue(T property) {
        TypeDescriptor actualType = this.propertyTypeRegistry.getTypeForProperty(property);
        return this.getValue(property, actualType);
    }

    public <O> O getValue(T property, Class<O> expectedType) {
        return this.getValue(property, TypeDescriptor.valueOf(expectedType));
    }

    public <O> O getValue(T property, TypeDescriptor expectedType) {
        Object originalValue;
        if (this.source.getProperties().containsKey(property)) {
            originalValue = this.source.getProperties().get(property);
        } else {
            originalValue = this.propertyTypeRegistry.getDefaultValueForProperty(property);
            this.set(property, originalValue);
        }
        return (O)this.propertyTypeRegistry.getConversionServiceForProperty(property).convert(originalValue, TypeDescriptor.forObject((Object)originalValue), expectedType);
    }

    public Object set(T property, Object value) {
        Object convertedValue = this.propertyTypeRegistry.getConversionServiceForProperty(property).convert(value, this.sourceValueClass);
        return this.source.getProperties().put(property, convertedValue);
    }

    @Override
    public int size() {
        return this.source.getProperties().size();
    }

    @Override
    public boolean isEmpty() {
        return this.source.getProperties().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.source.getProperties().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Object get(Object key) {
        return this.getValue(key);
    }

    @Override
    public Object put(T key, Object value) {
        return this.set(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.source.getProperties().remove(key);
    }

    @Override
    public void putAll(Map<? extends T, ?> m) {
        for (Map.Entry<T, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.source.getProperties().clear();
    }

    @Override
    public Set<T> keySet() {
        Set<Map.Entry<T, Object>> entries = this.entrySet();
        HashSet<T> list = new HashSet<T>();
        for (Map.Entry<T, Object> entry : entries) {
            list.add(entry.getKey());
        }
        return list;
    }

    @Override
    public Collection<Object> values() {
        Set<Map.Entry<T, Object>> entries = this.entrySet();
        ArrayList<Object> list = new ArrayList<Object>(entries.size());
        for (Map.Entry<T, Object> entry : entries) {
            list.add(entry.getValue());
        }
        return list;
    }

    @Override
    public Set<Map.Entry<T, Object>> entrySet() {
        HashSet<Map.Entry<T, Object>> entries = new HashSet<Map.Entry<T, Object>>();
        final TypedPropertyMap myself = this;
        for (final Object key : this.source.getProperties().keySet()) {
            entries.add(new Map.Entry<T, Object>(){

                @Override
                public T getKey() {
                    return key;
                }

                @Override
                public Object getValue() {
                    return myself.getValue(key);
                }

                @Override
                public Object setValue(Object value) {
                    return myself.set(this.getKey(), value);
                }
            });
        }
        return entries;
    }

    public TypedPropertyMap<T> detach() {
        HashMap<T, Object> sourceCopy = new HashMap<T, Object>();
        for (Map.Entry<T, Object> entry : this.entrySet()) {
            sourceCopy.put(entry.getKey(), entry.getValue());
        }
        return new TypedPropertyMap<T>(this.propertyTypeRegistry, sourceCopy, this.sourceValueClass);
    }
}

