/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.spring.validators;

import com.foreach.common.spring.validators.AtLeastOneNotNullField;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;

public class AtLeastOneNotNullFieldValidator
implements ConstraintValidator<AtLeastOneNotNullField, Object> {
    private String[] fieldNames;

    public void initialize(AtLeastOneNotNullField constraintAnnotation) {
        this.fieldNames = constraintAnnotation.fields();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null || this.fieldNames == null || this.fieldNames.length == 0) {
            return false;
        }
        boolean isValid = false;
        List<String> fieldNameList = Arrays.asList(this.fieldNames);
        Iterator<String> fieldNameIterator = fieldNameList.iterator();
        while (!isValid && fieldNameIterator.hasNext()) {
            String fieldName = fieldNameIterator.next();
            try {
                String property = BeanUtils.getProperty((Object)value, (String)fieldName);
                if (property == null) continue;
                isValid = true;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return isValid;
    }
}

