/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.common.test;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.MockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AnnotationConfigContextLoader;
import org.springframework.test.context.support.DelegatingSmartContextLoader;
import org.springframework.test.util.ReflectionTestUtils;

public class MockedLoader
extends DelegatingSmartContextLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MockedLoader.class);
    private AnnotationConfigContextLoaderDecorator loader = new AnnotationConfigContextLoaderDecorator();

    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        ReflectionTestUtils.setField((Object)((Object)this), (String)"annotationConfigLoader", (Object)((Object)this.loader));
        return super.loadContext(mergedConfig);
    }

    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        Class[] classes = configAttributes.getClasses();
        if (classes.length == 0) {
            configAttributes.setClasses(new Class[]{Object.class});
        }
        super.processContextConfiguration(configAttributes);
    }

    private static class BeanFactoryDecorator
    extends DefaultListableBeanFactory {
        private final Map<Class, Object> mockedBeans = new HashMap<Class, Object>();

        private BeanFactoryDecorator() {
        }

        public void destroySingletons() {
            super.destroySingletons();
            int mockedBeansWithoutInvocations = 0;
            int mockedBeansWithInvocations = 0;
            MockUtil mockUtil = new MockUtil();
            for (Map.Entry<Class, Object> entry : this.mockedBeans.entrySet()) {
                Object mock = entry.getValue();
                InvocationContainer container = mockUtil.getMockHandler(mock).getInvocationContainer();
                List invocations = container.getInvocations();
                if (invocations.isEmpty()) {
                    ++mockedBeansWithoutInvocations;
                } else {
                    ++mockedBeansWithInvocations;
                }
                Mockito.reset((Object[])new Object[]{mock});
            }
            LOG.debug("*** MockedLoader stats: [" + this.mockedBeans.size() + "] mocked beans of which [" + mockedBeansWithInvocations + "] with invocations and [" + mockedBeansWithoutInvocations + "] without invocations");
            this.mockedBeans.clear();
        }

        public Object resolveDependency(DependencyDescriptor descriptor, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) {
            try {
                return super.resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                Class dependencyType = descriptor.getDependencyType();
                if (Modifier.isFinal(dependencyType.getModifiers())) {
                    throw new NoSuchBeanDefinitionException(dependencyType, "Cannot create an automatic mock for final type: " + dependencyType);
                }
                Object mockedBean = this.mockedBeans.get(dependencyType);
                if (mockedBean == null) {
                    LOG.debug("Did not find a mocked bean for type {}", (Object)dependencyType);
                    mockedBean = Mockito.mock((Class)dependencyType);
                    this.mockedBeans.put(dependencyType, mockedBean);
                } else {
                    LOG.debug("returning mocked bean for type {}", (Object)dependencyType);
                }
                return mockedBean;
            }
        }
    }

    private class AnnotationConfigContextLoaderDecorator
    extends AnnotationConfigContextLoader {
        private AnnotationConfigContextLoaderDecorator() {
        }

        protected void prepareContext(GenericApplicationContext context) {
            QualifierAnnotationAutowireCandidateResolver qualifierAnnotationAutowireCandidateResolver = new QualifierAnnotationAutowireCandidateResolver();
            BeanFactoryDecorator beanFactoryDecorator = new BeanFactoryDecorator();
            beanFactoryDecorator.setAutowireCandidateResolver((AutowireCandidateResolver)qualifierAnnotationAutowireCandidateResolver);
            ReflectionTestUtils.setField((Object)context, (String)"beanFactory", (Object)((Object)beanFactoryDecorator));
            super.prepareContext(context);
        }
    }
}

