/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.LinuxFontPolicy;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.util.ScaledNumber;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;

public abstract class FlatLaf
extends BasicLookAndFeel {
    private static final String VARIABLE_PREFIX = "@";
    private static final String REF_PREFIX = "@@";
    private static final String OPTIONAL_PREFIX = "?";
    private static final String GLOBAL_PREFIX = "*.";
    private BasicLookAndFeel base;
    private String desktopPropertyName;
    private PropertyChangeListener desktopPropertyListener;
    private AWTEventListener mnemonicListener;
    private static boolean altKeyPressed;

    public static boolean install(LookAndFeel newLookAndFeel) {
        try {
            UIManager.setLookAndFeel(newLookAndFeel);
            return true;
        }
        catch (Exception ex) {
            System.err.println("Failed to initialize look and feel " + newLookAndFeel.getClass().getName());
            return false;
        }
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public void initialize() {
        this.getBase().initialize();
        super.initialize();
        this.mnemonicListener = e -> {
            if (e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 18) {
                FlatLaf.altKeyChanged(e.getID() == 401);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mnemonicListener, 8L);
        if (SystemInfo.IS_WINDOWS) {
            this.desktopPropertyName = "win.messagebox.font";
        } else if (SystemInfo.IS_LINUX) {
            this.desktopPropertyName = "gnome.Xft/DPI";
        }
        if (this.desktopPropertyName != null) {
            this.desktopPropertyListener = e -> FlatLaf.reSetLookAndFeel();
            Toolkit.getDefaultToolkit().addPropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
        }
    }

    @Override
    public void uninitialize() {
        if (this.desktopPropertyListener != null) {
            Toolkit.getDefaultToolkit().removePropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
            this.desktopPropertyName = null;
            this.desktopPropertyListener = null;
        }
        if (this.mnemonicListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.mnemonicListener);
            this.mnemonicListener = null;
        }
        if (this.base != null) {
            this.base.uninitialize();
        }
        super.uninitialize();
    }

    private BasicLookAndFeel getBase() {
        if (this.base == null) {
            if (SystemInfo.IS_MAC) {
                try {
                    this.base = (BasicLookAndFeel)Class.forName("com.apple.laf.AquaLookAndFeel").newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new IllegalStateException();
                }
            } else {
                this.base = new MetalLookAndFeel();
            }
        }
        return this.base;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = this.getBase().getDefaults();
        Color control = defaults.getColor("control");
        defaults.put("EditorPane.disabledBackground", control);
        defaults.put("EditorPane.inactiveBackground", control);
        defaults.put("FormattedTextField.disabledBackground", control);
        defaults.put("PasswordField.disabledBackground", control);
        defaults.put("TextArea.disabledBackground", control);
        defaults.put("TextArea.inactiveBackground", control);
        defaults.put("TextField.disabledBackground", control);
        defaults.put("TextPane.disabledBackground", control);
        defaults.put("TextPane.inactiveBackground", control);
        defaults.put("Spinner.disabledBackground", control);
        defaults.put("Spinner.disabledForeground", control);
        boolean useScreenMenuBar = SystemInfo.IS_MAC && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
        Object aquaMenuBarUI = useScreenMenuBar ? defaults.get("MenuBarUI") : null;
        this.initFonts(defaults);
        this.loadDefaultsFromProperties(defaults);
        if (useScreenMenuBar) {
            defaults.put("MenuBarUI", aquaMenuBarUI);
        }
        return defaults;
    }

    private void initFonts(UIDefaults defaults) {
        Font font;
        FontUIResource uiFont = null;
        if (SystemInfo.IS_WINDOWS) {
            Font winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
            if (winFont != null) {
                uiFont = new FontUIResource(winFont);
            }
        } else if (SystemInfo.IS_MAC) {
            font = defaults.getFont("Label.font");
            if (SystemInfo.IS_MAC_OS_10_11_EL_CAPITAN_OR_LATER) {
                font = new FontUIResource(".SF NS Text", font.getStyle(), font.getSize());
            }
            uiFont = font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        } else if (SystemInfo.IS_LINUX) {
            font = LinuxFontPolicy.getFont();
            FontUIResource fontUIResource = uiFont = font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        }
        if (uiFont == null) {
            return;
        }
        uiFont = UIScale.applyCustomScaleFactor(uiFont);
        for (Object key : defaults.keySet()) {
            if (!(key instanceof String) || !((String)key).endsWith(".font")) continue;
            defaults.put(key, uiFont);
        }
        defaults.put("MenuItem.acceleratorFont", uiFont);
    }

    private void loadDefaultsFromProperties(UIDefaults defaults) {
        ArrayList lafClasses = new ArrayList();
        Class<?> lafClass = this.getClass();
        while (FlatLaf.class.isAssignableFrom(lafClass)) {
            lafClasses.add(0, lafClass);
            lafClass = lafClass.getSuperclass();
        }
        try {
            String key;
            Properties properties = new Properties();
            for (Class clazz : lafClasses) {
                String propertiesName = "/" + clazz.getName().replace('.', '/') + ".properties";
                InputStream in = clazz.getResourceAsStream(propertiesName);
                try {
                    if (in == null) continue;
                    properties.load(in);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            Function<String, String> resolver = value -> this.resolveValue(properties, (String)value);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                key = (String)e.getKey();
                if (!key.startsWith(GLOBAL_PREFIX)) continue;
                String value2 = this.resolveValue(properties, (String)e.getValue());
                hashMap.put(key.substring(GLOBAL_PREFIX.length()), this.parseValue(key, value2, resolver));
            }
            for (Map.Entry<Object, Object> key2 : defaults.keySet()) {
                String skey;
                String globalKey;
                Object globalValue;
                if (!(key2 instanceof String) || !((String)((Object)key2)).contains(".") || (globalValue = hashMap.get(globalKey = (skey = (String)((Object)key2)).substring(skey.lastIndexOf(46) + 1))) == null) continue;
                defaults.put(key2, globalValue);
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                key = (String)e.getKey();
                if (key.startsWith(VARIABLE_PREFIX) || key.startsWith(GLOBAL_PREFIX)) continue;
                String value2 = this.resolveValue(properties, (String)e.getValue());
                defaults.put(key, this.parseValue(key, value2, resolver));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String resolveValue(Properties properties, String value) {
        String newValue;
        if (!value.startsWith(VARIABLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(REF_PREFIX)) {
            value = value.substring(REF_PREFIX.length());
        }
        boolean optional = false;
        if (value.startsWith(OPTIONAL_PREFIX)) {
            value = value.substring(OPTIONAL_PREFIX.length());
            optional = true;
        }
        if ((newValue = properties.getProperty(value)) == null) {
            if (optional) {
                return "null";
            }
            System.err.println("variable or reference '" + value + "' not found");
            throw new IllegalArgumentException(value);
        }
        return this.resolveValue(properties, newValue);
    }

    private Object parseValue(String key, String value, Function<String, String> resolver) {
        switch (value = value.trim()) {
            case "null": {
                return null;
            }
            case "false": {
                return false;
            }
            case "true": {
                return true;
            }
        }
        if (key.endsWith(".border") || key.endsWith("Border")) {
            return this.parseBorder(value, resolver);
        }
        if (key.endsWith(".icon") || key.endsWith("Icon")) {
            return this.parseInstance(value);
        }
        if (key.endsWith(".margin") || key.endsWith(".padding") || key.endsWith("Margins") || key.endsWith("Insets")) {
            return this.parseInsets(value);
        }
        ScaledNumber scaledNumber = this.parseScaledNumber(key, value);
        if (scaledNumber != null) {
            return scaledNumber;
        }
        if (key.endsWith("Size") && !key.equals("SplitPane.dividerSize")) {
            return this.parseSize(value);
        }
        if (key.endsWith("Width") || key.endsWith("Height")) {
            return this.parseInteger(value, true);
        }
        ColorUIResource color = this.parseColor(value, false);
        if (color != null) {
            return color;
        }
        Integer integer = this.parseInteger(value, false);
        if (integer != null) {
            return integer;
        }
        return value;
    }

    private Object parseBorder(String value, Function<String, String> resolver) {
        if (value.indexOf(44) >= 0) {
            List<String> parts = FlatLaf.split(value, ',');
            Insets insets = this.parseInsets(value);
            ColorUIResource lineColor = parts.size() == 5 ? this.parseColor(resolver.apply(parts.get(4)), true) : null;
            return t -> lineColor != null ? new FlatLineBorder(insets, lineColor) : new FlatEmptyBorder(insets);
        }
        return this.parseInstance(value);
    }

    private Object parseInstance(String value) {
        return t -> {
            try {
                return Class.forName(value).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
        };
    }

    private Insets parseInsets(String value) {
        List<String> numbers = FlatLaf.split(value, ',');
        try {
            return new InsetsUIResource(Integer.parseInt(numbers.get(0)), Integer.parseInt(numbers.get(1)), Integer.parseInt(numbers.get(2)), Integer.parseInt(numbers.get(3)));
        }
        catch (NumberFormatException ex) {
            System.err.println("invalid insets '" + value + "'");
            throw ex;
        }
    }

    private Dimension parseSize(String value) {
        List<String> numbers = FlatLaf.split(value, ',');
        try {
            return new DimensionUIResource(Integer.parseInt(numbers.get(0)), Integer.parseInt(numbers.get(1)));
        }
        catch (NumberFormatException ex) {
            System.err.println("invalid size '" + value + "'");
            throw ex;
        }
    }

    private ColorUIResource parseColor(String value, boolean reportError) {
        block5: {
            try {
                int rgb = Integer.parseInt(value, 16);
                if (value.length() == 6) {
                    return new ColorUIResource(rgb);
                }
                if (value.length() == 8) {
                    return new ColorUIResource(new Color(rgb, true));
                }
                if (reportError) {
                    throw new NumberFormatException(value);
                }
            }
            catch (NumberFormatException ex) {
                if (!reportError) break block5;
                System.err.println("invalid color '" + value + "'");
                throw ex;
            }
        }
        return null;
    }

    private Integer parseInteger(String value, boolean reportError) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            if (reportError) {
                System.err.println("invalid integer '" + value + "'");
                throw ex;
            }
            return null;
        }
    }

    private ScaledNumber parseScaledNumber(String key, String value) {
        if (!(key.equals("OptionPane.buttonMinimumWidth") || key.equals("SplitPane.oneTouchButtonSize") || key.equals("SplitPane.oneTouchButtonOffset"))) {
            return null;
        }
        try {
            return new ScaledNumber(Integer.parseInt(value));
        }
        catch (NumberFormatException ex) {
            System.err.println("invalid integer '" + value + "'");
            throw ex;
        }
    }

    public static List<String> split(String str, char delim) {
        ArrayList<String> strs = new ArrayList<String>();
        int delimIndex = str.indexOf(delim);
        int index = 0;
        while (delimIndex >= 0) {
            strs.add(str.substring(index, delimIndex));
            index = delimIndex + 1;
            delimIndex = str.indexOf(delim, index);
        }
        strs.add(str.substring(index));
        return strs;
    }

    private static void reSetLookAndFeel() {
        EventQueue.invokeLater(() -> {
            try {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                UIManager.setLookAndFeel(lookAndFeel);
                PropertyChangeEvent e = new PropertyChangeEvent(UIManager.class, "lookAndFeel", lookAndFeel, lookAndFeel);
                for (PropertyChangeListener l : UIManager.getPropertyChangeListeners()) {
                    l.propertyChange(e);
                }
                FlatLaf.updateUI();
            }
            catch (UnsupportedLookAndFeelException ex) {
                ex.printStackTrace();
            }
        });
    }

    public static void updateUI() {
        for (Window w : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(w);
        }
    }

    public static boolean isShowMnemonics() {
        return altKeyPressed || !UIManager.getBoolean("Component.hideMnemonics");
    }

    private static void altKeyChanged(boolean pressed) {
        if (pressed == altKeyPressed) {
            return;
        }
        altKeyPressed = pressed;
        if (!UIManager.getBoolean("Component.hideMnemonics")) {
            return;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return;
        }
        Window window = SwingUtilities.windowForComponent(focusOwner);
        if (window == null) {
            return;
        }
        FlatLaf.repaintMnemonics(window);
    }

    private static void repaintMnemonics(Container container) {
        for (Component c : container.getComponents()) {
            if (FlatLaf.hasMnemonic(c)) {
                c.repaint();
            }
            if (!(c instanceof Container)) continue;
            FlatLaf.repaintMnemonics((Container)c);
        }
    }

    private static boolean hasMnemonic(Component c) {
        if (c instanceof JLabel && ((JLabel)c).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (c instanceof AbstractButton && ((AbstractButton)c).getDisplayedMnemonicIndex() >= 0) {
            return true;
        }
        if (c instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)c;
            int tabCount = tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (tabPane.getDisplayedMnemonicIndexAt(i) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

