/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class FlatSliderUI
extends BasicSliderUI {
    private int trackWidth;
    private int thumbWidth;
    private Color trackColor;
    private Color thumbColor;
    private Color focusColor;
    private Color hoverColor;
    private Color disabledForeground;
    private MouseListener hoverListener;
    private boolean hover;

    public static ComponentUI createUI(JComponent c) {
        return new FlatSliderUI();
    }

    public FlatSliderUI() {
        super(null);
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        this.hoverListener = new FlatUIUtils.HoverListener(slider, h -> {
            this.hover = h;
        });
        slider.addMouseListener(this.hoverListener);
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.hoverListener);
        this.hoverListener = null;
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.trackWidth = UIManager.getInt("Slider.trackWidth");
        this.thumbWidth = UIManager.getInt("Slider.thumbWidth");
        this.trackColor = UIManager.getColor("Slider.trackColor");
        this.thumbColor = UIManager.getColor("Slider.thumbColor");
        this.focusColor = UIManager.getColor("Slider.focusedColor");
        this.hoverColor = FlatUIUtils.getUIColor("Slider.hoverColor", this.focusColor);
        this.disabledForeground = UIManager.getColor("Slider.disabledForeground");
    }

    @Override
    protected void uninstallDefaults(JSlider slider) {
        super.uninstallDefaults(slider);
        this.trackColor = null;
        this.thumbColor = null;
        this.focusColor = null;
        this.hoverColor = null;
        this.disabledForeground = null;
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return UIScale.scale(super.getPreferredHorizontalSize());
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return UIScale.scale(super.getPreferredVerticalSize());
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return UIScale.scale(super.getMinimumHorizontalSize());
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return UIScale.scale(super.getMinimumVerticalSize());
    }

    @Override
    protected int getTickLength() {
        return UIScale.scale(super.getTickLength());
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(UIScale.scale(this.thumbWidth), UIScale.scale(this.thumbWidth));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        FlatUIUtils.setRenderingHints((Graphics2D)g);
        super.paint(g, c);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintTrack(Graphics g) {
        RoundRectangle2D.Float track;
        float tw;
        boolean enabled = this.slider.isEnabled();
        float arc = tw = UIScale.scale((float)this.trackWidth);
        RoundRectangle2D.Float coloredTrack = null;
        if (this.slider.getOrientation() == 0) {
            float y = (float)this.trackRect.y + ((float)this.trackRect.height - tw) / 2.0f;
            if (enabled && this.isRoundThumb()) {
                int cw = this.thumbRect.x + this.thumbRect.width / 2 - this.trackRect.x;
                coloredTrack = new RoundRectangle2D.Float(this.trackRect.x, y, cw, tw, arc, arc);
                track = new RoundRectangle2D.Float(this.trackRect.x + cw, y, this.trackRect.width - cw, tw, arc, arc);
            } else {
                track = new RoundRectangle2D.Float(this.trackRect.x, y, this.trackRect.width, tw, arc, arc);
            }
        } else {
            float x = (float)this.trackRect.x + ((float)this.trackRect.width - tw) / 2.0f;
            if (enabled && this.isRoundThumb()) {
                int ch = this.thumbRect.y + this.thumbRect.height / 2 - this.trackRect.y;
                track = new RoundRectangle2D.Float(x, this.trackRect.y, tw, ch, arc, arc);
                coloredTrack = new RoundRectangle2D.Float(x, this.trackRect.y + ch, tw, this.trackRect.height - ch, arc, arc);
            } else {
                track = new RoundRectangle2D.Float(x, this.trackRect.y, tw, this.trackRect.height, arc, arc);
            }
        }
        if (coloredTrack != null) {
            g.setColor(this.slider.hasFocus() ? this.focusColor : (this.hover ? this.hoverColor : this.thumbColor));
            ((Graphics2D)g).fill(coloredTrack);
        }
        g.setColor(enabled ? this.trackColor : this.disabledForeground);
        ((Graphics2D)g).fill(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintThumb(Graphics g) {
        g.setColor(this.slider.isEnabled() ? (this.slider.hasFocus() ? this.focusColor : (this.hover ? this.hoverColor : this.thumbColor)) : this.disabledForeground);
        if (this.isRoundThumb()) {
            g.fillOval(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        } else {
            double w = this.thumbRect.width;
            double h = this.thumbRect.height;
            double wh = w / 2.0;
            Path2D thumb = FlatUIUtils.createPath(0.0, 0.0, w, 0.0, w, h - wh, wh, h, 0.0, h - wh);
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.translate(this.thumbRect.x, this.thumbRect.y);
                if (this.slider.getOrientation() == 1) {
                    if (this.slider.getComponentOrientation().isLeftToRight()) {
                        g2.translate(0, this.thumbRect.height);
                        g2.rotate(Math.toRadians(270.0));
                    } else {
                        g2.translate(this.thumbRect.width, 0);
                        g2.rotate(Math.toRadians(90.0));
                    }
                }
                g2.fill(thumb);
            }
            finally {
                g2.dispose();
            }
        }
    }

    private boolean isRoundThumb() {
        return !this.slider.getPaintTicks() && !this.slider.getPaintLabels();
    }
}

