/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class FlatTextFieldUI
extends BasicTextFieldUI {
    protected int focusWidth;
    protected int minimumWidth;
    private Handler handler;

    public static ComponentUI createUI(JComponent c) {
        return new FlatTextFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.focusWidth = UIManager.getInt("Component.focusWidth");
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        MigLayoutVisualPadding.install((JComponent)this.getComponent(), this.focusWidth);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        MigLayoutVisualPadding.uninstall(this.getComponent());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this.getHandler());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.getHandler());
        this.handler = null;
    }

    public Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        FlatUIUtils.paintParentBackground(g, c);
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints(g2);
            float focusWidth = c.getBorder() instanceof FlatBorder ? UIScale.scale((float)this.focusWidth) : 0.0f;
            g2.setColor(c.getBackground());
            FlatUIUtils.fillRoundRectangle(g2, 0, 0, c.getWidth(), c.getHeight(), focusWidth, 0.0f);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.applyMinimumWidth(super.getPreferredSize(c), c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.applyMinimumWidth(super.getMinimumSize(c), c);
    }

    private Dimension applyMinimumWidth(Dimension size, JComponent c) {
        Container parent = c.getParent();
        if (parent instanceof JComboBox || parent instanceof JSpinner || parent != null && parent.getParent() instanceof JSpinner) {
            return size;
        }
        size.width = Math.max(size.width, UIScale.scale(this.minimumWidth + this.focusWidth * 2));
        return size;
    }

    private class Handler
    implements FocusListener {
        private Handler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            FlatTextFieldUI.this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            FlatTextFieldUI.this.getComponent().repaint();
        }
    }
}

